package de.jbible.service.ImportDBG;
/**
 * Token descriptor class of the import filter of
 * the ASCII texts from the deutsche bibelgesellschaft.
 */
public class Yytoken
{

    /**
     * Create a new token object.
     *
     * @param type Specify the type of the token. See the TYPE_ defines.
     * @param text The text of this token
     * @param line The line where this data comes from.
     */
    public Yytoken (int type,String text,int line)
    {
        _type = type;
        _line = line+1;
        _text = text;
    }

    /**
     * Create a new token object without text.
     *
     * @param type Specify the type of the token. See the TYPE_ defines.
     * @param line The line where this data comes from.
     */
    public Yytoken (int type,int line)
    {
        _type = type;
        _line = line+1;
    }
    /** The token type. See TYPE_ constants. */
    public int _type;

    /** The text of this token. */
    public String _text;

    /** From which line does this token comes from? */
    public int _line;

    /** Debugging only. */
    public String toString()
    {
        return "Token ("+_type+") "+tokenName (_type)+": "+_text+" (line "+_line+")";
    }


    /**

     * Return the name of a given token.
     *
     * @param token The token value.
     * @return The name of the token.
     */
    public static String tokenName (int token)
    {
    	switch (token)
        {
        	case ImportDBGParser.WORD : return "Word";
			case ImportDBGParser.NUMBER : return "Number";
			case ImportDBGParser.BOOK : return "Book";
		    case ImportDBGParser.CHAPTER  : return  "Chapter";
		    case ImportDBGParser.VERS  : return  "Vers";
		    case ImportDBGParser.START_HEADLINE : return "Start Headline";
		    case ImportDBGParser.END_HEADLINE : return "End Headline";
		    case ImportDBGParser.START_PARAGRAPH_PARALLEL : return "Start Paragraph Parallel";
		    case ImportDBGParser.END_PARAGRAPH_PARALLEL : return "End Paragraph Parallel";
		    case ImportDBGParser.START_WORD_PARALLEL : return "Start Word Parallel";
		    case ImportDBGParser.END_WORD_PARALLEL : return "End Word Parallel";
		    case ImportDBGParser.START_COMMENT : return "Start Comment";
		    case ImportDBGParser.END_COMMENT : return "End Comment";
		    case ImportDBGParser.START_EXPLANATION : return "Start Explanation";
		    case ImportDBGParser.END_EXPLANATION : return "End Explanation";
		    case ImportDBGParser.COMMENT_MARKER : return "Comment Marker";
		    case ImportDBGParser.PARALLEL_MARKER : return "Parallel Marker";
		    case ImportDBGParser.EOF : return "EOF";
    	}

        return "Unknown Token: "+token;

    }

}

