package de.jbible.service.ImportDialog;

import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.table.*;

import de.jbible.core.*;

/**
 * This dialog is used to collect all files of an import.
 *
 * It is created with the first place to search. It is copying
 * all files to a temporary place and ask the user for more files
 * while displaying him the status of the missing files.
 */
public class CollectFiles extends JPanel
{
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel descPanel = new JPanel();
    JLabel desc2Label = new JLabel();
    JLabel desc1Label = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel contentPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton cancelButton = new JButton();
    JLabel desc3Label = new JLabel();
    JTable statusTable = new JTable();
    GridLayout gridLayout2 = new GridLayout();

    /** Not allowed. */
    private CollectFiles() {}

    /**
     * Create a new Panel.
     *
     * @param context The service context of this dialog
     * @param importFile The (first) file to import.
     * @param selection The Data object of the selection
     * @param windowService The window service to create a progress window
     */
    public CollectFiles(ServiceContext context,
        File importFile,ImportDialogPanel.Data selection,WindowService windowService,
        String firstPath,Object[][] files)
    {
        // store variables:
        _context = context;
        _selection = selection;
        _importFile = importFile;
        _windowService = windowService;
        _files = files;

        // create temporary path name
        String title = importFile.getName();
//        _tempPath = 

        // create status:
//        copyFiles (firstPath,);
//        checkFiles (firstPath,files,false)


        try
        {
            jbInit();
        }
        catch(Exception ex)
        {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception
    {
        this.setLayout(borderLayout1);
        desc2Label.setText("Bitte whlen Sie die Verzeichnisse mit den fehlenden Dateien aus,");
        desc1Label.setText("Es konnten nicht alle Dateien fr den import gefunden werden.");
        descPanel.setLayout(gridLayout1);
        gridLayout1.setRows(3);
        cancelButton.setText("jButton1");
        desc3Label.setText("oder wechseln Sie die Diskette.");
        contentPanel.setLayout(gridLayout2);
        gridLayout2.setColumns(2);
        this.add(descPanel, BorderLayout.NORTH);
        descPanel.add(desc1Label, null);
        descPanel.add(desc2Label, null);
        descPanel.add(desc3Label, null);
        this.add(contentPanel, BorderLayout.CENTER);
        contentPanel.add(statusTable, null);
        this.add(buttonPanel, BorderLayout.SOUTH);
        buttonPanel.add(cancelButton, null);

        // create Table model:
        TableModel model = new DefaultTableModel ();


        statusTable.setModel(model);

    }


    /** The context of this dialog. */
    private ServiceContext _context;
    /** The first selected import file. */
    private File _importFile;
    /** The selected filter. */
    private ImportDialogPanel.Data _selection;
    /** The window service this belongs to. */
    private WindowService _windowService;
    /** The files array. */
    private Object[][] _files;

    /** The temporary path where we store our files.*/
    private static File _tempBasePath;

    /** Evaluate the temp path of this system.*/
    static
    {
        File f = null;
        try
        {
            f = File.createTempFile ("JBible",null,null);
            _tempBasePath = new File (f.getParent ());
        }
        catch (IOException ex)
        {
            LoggingManager.error("Cant create temp file.",null);
        }
        finally
        {
            if (f != null)
            {
                f.delete ();
            }
        }
    }

}