package de.jbible.service.ImportDialog;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import de.jbible.core.*;
import de.jbible.tool.swinglang.*;
import de.jbible.tool.swingmisc.*;


/**
 * This service provides a dialog for importing bibles.
 *
 * This service deals with all services that implements the
 * ImportFilterService interface.
 *
 * @see de.jbible.core#ImportFilterService
 */


public class ImportDialog extends DefaultService implements Service
{
    /**
     * Init: Gets all Import Services from the manager.
     * Registers this service in all window services
     *
     * @param context The context of the service
     */
    public void init(ServiceContext context)
    {
        super.init(context);

        // register name and resource bundle:
        context.registerTitle("Import Dialog Service");
        context.registerResourceBundle("de.jbible.service.ImportDialog.ImportDialogResourceBundle");

    }

    /**
     * Register service into all window services.
     */
    public void start ()
    {
        // get all BibleImportFilters
        _importServices = _context.getServices(de.jbible.core.ImportFilterService.class);

        // register this service in all window services:

        // get all Services that implements WindowService.class
        java.util.List serv = _context.getServices (de.jbible.core.WindowService.class);

        if (serv != null)
        {
            Iterator winServices = serv.iterator();
            WindowService ws;

            while (winServices.hasNext())
            {
                ws = (WindowService)winServices.next();

                try
                {
                    ws.registerAction (
                        "IDS_import",
                        WindowService.GRP_FILE,
                        new ServiceActionListener (ws) {
                            public void actionPerformed (ActionEvent e)
                            {   createImportDialog ((WindowService)_service,e); }
                        },
                        _icon,
                        "IDS_import_desc");
                }
                catch (IllegalGroupException ex)
                {
                    ex.printStackTrace();
                }                         
            }
        }
    }

    /**
     * Create the Import Dialog.
     *
     * @param event The event that has occured
     */
    private void createImportDialog (WindowService ws,ActionEvent event)
    {
        // Create dialog:
        JPanel basePanel;
        boolean blNoFilter;

        if (_importServices != null && _importServices.size() > 0)
        {
            basePanel= new ImportDialogPanel (_context,_importServices,ws);
            blNoFilter = false;
        }
        else
        {
            // no import service is registered, show just a Message
            basePanel = new JPanel ();
            basePanel.setLayout(new BorderLayout());
            LangJButton ok = new LangJButton (_context);
            ok.setText ("IDS_OK");
            ok.addActionListener(new CloseDialogActionListener ());

            JPanel buttonPanel = new JPanel ();

            buttonPanel.add (ok);
            basePanel.add (buttonPanel,BorderLayout.SOUTH);
            basePanel.add (new LangJLabel ("IDS_noImportFilter",_context),BorderLayout.CENTER);
            blNoFilter = true;
        }

        // Create Dialog:
        Window win = ws.createDialog("IDS_import",basePanel,_icon);
        win.pack();
        win.validate();
        win.setVisible (true);

        if (!blNoFilter)
        {
            // handle first selection
            ((ImportDialogPanel)basePanel).postinit ();
        }

    }

    /** The list of all importing services. */
    private java.util.List _importServices;

    /** The Icon of this service. */
    static final String _icon = "de/jbible/service/importdialog/import.gif";


}

