package de.jbible.service.ImportDialog;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.text.*;

import de.jbible.tool.swinglang.*;
import de.jbible.tool.swingmisc.*;
import de.jbible.tool.bibleimport.*;
import de.jbible.core.*;
import de.jbible.bible.*;


/**
 * This class implements the first panel of the import dialog.
 */
public class ImportDialogPanel  extends JPanel
{
    /** Dialog component. */
    private BorderLayout baseBorderLayout = new BorderLayout();
    /** Dialog component. */
    private JPanel buttonPanel = new JPanel();
    /** Dialog component. */
    private JPanel inputBasePanel = new JPanel();
    /** Dialog component. */
    private JPanel innerButtonPanel = new JPanel();
    /** Dialog component. */
    private FlowLayout buttonPanelLayout = new FlowLayout(FlowLayout.CENTER);
    /** Dialog component. */
    private GridLayout innerButtonPanelLayout = new GridLayout();
    /** Dialog component. */
    private BorderLayout inputBasePanelLayout = new BorderLayout();
    /** Dialog component. */
    private JPanel inputPanel = new JPanel();
    /** Dialog component. */
    private JPanel fileInputBrowsePanel = new JPanel();
    /** Dialog component. */
    private JTextField fileTextField = new JTextField();
    /** Dialog component. */
    private GridLayout inputPanelLayout = new GridLayout();
    /** Dialog component. */
    private JPanel selectFilterPanel = new JPanel();
    /** Dialog component. */
    private FlowLayout selectFilterPanelLayout = new FlowLayout();
    /** Dialog component. */
    private FlowLayout fileInputBrowsePanelLayout = new FlowLayout();

    /** Language dependend dialog component. */
    private LangJTextArea infoPane;
    /** Language dependend dialog component. */
    private LangJButton startButton;
    /** Language dependend dialog component. */
    private LangJButton readyButton;
    /** Language dependend dialog component. */
    private LangJButton browseFileButton;
    /** Language dependend dialog component. */
    private LangJComboBox selectFilter;
    /** Language dependend dialog component. */
    private LangJLabel filterSelectionLabel;
    /** Language dependend dialog component. */
    private LangJLabel fileInputLabel;


    /**
     * Create a new dialog panel.
     *
     * @param context The context of the panel.
     * @param importService A list of all import services that are installed.
     * @param ws The window service.
     */
    public ImportDialogPanel(ServiceContext context,java.util.List importService,
        WindowService ws)
    {
        startButton = new LangJButton(context);
        readyButton = new LangJButton(context);
        browseFileButton = new LangJButton(context);
        selectFilter = new LangJComboBox(context);
        filterSelectionLabel = new LangJLabel(context);
        fileInputLabel = new LangJLabel(context);
        infoPane = new LangJTextArea(context);
        _context = context;
        _windowService = ws;


        createImportServiceList (importService);

        try
        {
            jbInit();
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }

    /**
     * Init the dialog.
     */
    private void jbInit()
    {
        this.setLayout(baseBorderLayout);

        // Init Start Button:
        startButton.setText("IDS_start");
        startButton.addActionListener(new ActionListener () {
            public void actionPerformed(ActionEvent e)
                { doImport (); }});

        // Init Ready Button
        readyButton.setText("IDS_ready");
        readyButton.addActionListener(new CloseDialogActionListener ());


        // init selectFilter
        selectFilter.addActionListener(new ActionListener () {
            public void actionPerformed(ActionEvent e)
                { filterSelected (e); }});


        infoPane.setWrapStyleWord(true);
        infoPane.setLineWrap(true);

        innerButtonPanel.setLayout(innerButtonPanelLayout);
        buttonPanel.setLayout(buttonPanelLayout);
        inputBasePanel.setLayout(inputBasePanelLayout);
        inputPanel.setLayout(inputPanelLayout);

        infoPane.setEditable(false);
        filterSelectionLabel.setText("IDS_selectFilter");
        fileInputLabel.setText("IDS_selectFile");
        browseFileButton.setText("IDS_browse");
        browseFileButton.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent e)
                { doBrowse (); }});


        fileTextField.setColumns(20);
        // Focus listener must check, if the file is valid for the filter:
        fileTextField.addFocusListener(new FocusListener () {
            public void focusGained(FocusEvent e) {}
            public void focusLost(FocusEvent e){ textLostFocus (); }});


        inputPanelLayout.setRows(4);
        selectFilterPanel.setLayout(selectFilterPanelLayout);
        selectFilterPanelLayout.setAlignment(FlowLayout.LEFT);
        fileInputBrowsePanel.setLayout(fileInputBrowsePanelLayout);
        fileInputBrowsePanelLayout.setAlignment(FlowLayout.LEFT);
        innerButtonPanelLayout.setColumns(2);
        innerButtonPanelLayout.setHgap(20);
        this.add(inputBasePanel, BorderLayout.CENTER);
        inputBasePanel.add(inputPanel, BorderLayout.NORTH);
        inputPanel.add(filterSelectionLabel, null);
        inputPanel.add(selectFilterPanel, null);
        selectFilterPanel.add(selectFilter, null);
        inputPanel.add(fileInputLabel, null);
        inputPanel.add(fileInputBrowsePanel, null);
        fileInputBrowsePanel.add(fileTextField, null);
        fileInputBrowsePanel.add(browseFileButton, null);
        inputBasePanel.add(infoPane, BorderLayout.CENTER);
        this.add(buttonPanel, BorderLayout.SOUTH);
        buttonPanel.add(innerButtonPanel, null);
        innerButtonPanel.add(startButton, null);
        innerButtonPanel.add(readyButton, null);
    }

    /**
     * Stores the data from one import filter.
     *
     * Objects of this type are stored in a hash table. The name of the
     * import is the key.
     */
    class Data
    {
        /**
         * Create new object with given name, service and index.
         *
         * @param s The services that handles this import.
         * @param i The index of this import within the service.
         */
        public Data (ImportFilterService s,int i)
        {
            service = s;
            index = i;
        }
        /** The services that handles this import. */
        public ImportFilterService service;
        /** The services that handles this import. */
        public int index;
    }

    /**
     * Create a import service list.
     *
     * Aks all services about the supported imports and
     * create a list from all this data. For storing the
     * inner class Data is used.
     *
     * @see Data
     */
    private void createImportServiceList (java.util.List services)
    {
        Iterator iter = services.iterator();
        ImportFilterService ifs;
        String names[];
        int i;
        Data d;
        LangComboBoxModel model = (LangComboBoxModel)selectFilter.getModel ();

        while (iter.hasNext())
        {
            ifs = (ImportFilterService)iter.next();

            // get names array
            names = ifs.getTranslationTitle();

            // iterate over all names:
            for (i=0;i<names.length;i++)
            {
                // store in Data array
                d = new Data (ifs,i);
                importServices.put(names[i],d);

                // add to combo box
                model.addElement(names[i]);

            }
        }

    }

    /**
     * Some initialisations after the dialog is visible.
     *
     * Calls filterSelected() and register a UIChange object in the frame.
     */
    void postinit ()
    {
        // set the last filename as default:
        fileTextField.setText(_context.getProperty("last_file"));

        filterSelected (null);

        Component f = this.getRootPane().getParent();

        // add the UpdateUIListener:
        if (f instanceof WindowUpdateInterface)
        {
            ((WindowUpdateInterface)f).addUIListener (new UpdateUIListener(){
                public void uiChanged () { uiUpdated (); }});
        }

        // init plaf changes
        uiUpdated ();

    }

    /**
     * Our TextArea should look like a label.
     */
    private void uiUpdated ()
    {
        UIDefaults defs = UIManager.getDefaults();
        Color c = (Color)defs.get ("Label.background");
        infoPane.setBackground(c);
        c = (Color)defs.get ("Label.foreground");
        infoPane.setForeground(c);
        Font f = (Font)defs.get ("Label.font");
        infoPane.setFont(f);
    }

    /**
     * Do the import.
     */
    private void doImport ()
    {
        ImportFilterService sve = _selection.service;
        int index = _selection.index;

        // check data type:
//        int type = sve.getDataTypes()[index];
        String title = _actual.getName();

        // store selection for the next call of this dialog:
        _context.setProperty("last_file",_actual.getPath());


        // be sure that all files are in one directory, with the correct
        // size
        Object[][]files = sve.getFileList(index);

        // compute the actual selected path and check, if all files are there:
        String path = null;

        // did we have a file or a path
        if (_actual.isDirectory())
        {
            path = _actual.getPath();
        }
        else
        {
            path = _actual.getParent();
        }

        if (checkFiles (path,files,false) == false)
        {
            // create dialog:
            CollectFiles col = new CollectFiles (_context,_actual,_selection,
                _windowService,path,files);
            Window win = _windowService.createDialog("IDS_CollectFiles",
                col,ImportDialog._icon);
            win.pack();
            win.validate();
            win.setVisible(true);

        }
        else
        {
            startImport (_actual,_selection,_windowService,_context);
        }
    }

    /**
     * The final importing process.
     *
     * Either the CollectFile Dialog or the doImport method calls
     * this method. This method is static because a dependency between
     * the object and this method is not allowed. The problem: While
     * the CollectFile dialog is open, the user might start another
     * import, so if the CollectFile dialog returns, this object might have
     * changed.
     *
     * @param importFile The (first) file to import.
     * @param selection The Data object of the selection
     * @param windowService The window service to create a progress window
     */
    static void startImport (File importFile,Data selection,
    	WindowService windowService,ServiceContext context)
    {

        ImportFilterService sve = selection.service;
        int index = selection.index;
        int type = sve.getDataTypes()[index];
        String title = importFile.getName();

        // create progress facility
        ProgressWindowInterface pw = windowService.createProgressWindow
            (title,ImportDialog._icon);


        if (type == ImportFilterService.BIBLETRANSLATION)
        {
            BibleImportReader reader = null;
            BibleImportWriter writer = null;

            // create reader:
            try
            {
                reader = sve.createImportReader(importFile,index);

                // create writer
                writer = new BibleImportWriter (reader,pw,
        			context);

                // start importing in a new thread
                Thread t = new Thread(writer,"Import "+title);
                t.setPriority(Thread.NORM_PRIORITY+2);
                t.start();
            }
            catch (IOException ex)
            {
                LoggingManager.error("Error while opening bible import reader",
                    ex,"ImportDialogService");
            }
            finally
            {
                if (reader != null)
                {
                    try
                    {
                        reader.close ();
                    }
                    catch (IOException ex){}
                }
            }

        }
    }

    /**
     * Check, if all files are in the specified directory.
     *
     * You can switch on the log flag. In this case the trird
     * column of the file array is upated: The Reference is set
     * to the {@link #_found _found} Object in this class.
     *
     * The second column can contain the size of the files. If these
     * references are not null, the size will be checked.
     *
     * @param path The path where the files should be.
     * @param files The files array. Column 1: The file name, type String.
     *  Column 2: Optional, The file size, type: Integer,
     *  Column 3: Log Flag: "File found", type: null=not found, else found
     * @param doLog The log flag
     * @return true: All files are ok, else false.
     */
    boolean checkFiles (String path,Object[][] files,boolean doLog)
    {
        // get a list of all files in this directory
        File p = new File (path==null?"":path);

        String []list = p.list();
        if (list == null)
            return false; // nothing in path!

        boolean result = true;
        int i,j;
        File test;
        File[] cache = new File[list.length];
        boolean found;
        long size;

        // check list against files:
        for (j=0;j<files.length;j++)
        {
            found = false;
            test = new File (path,(String)files[j][0]);

            for (i=0;i<list.length;i++)
            {
                if (cache[i] == null)
                    cache[i] = new File (path,list[i]);

                if (test.compareTo(cache[i]) == 0)
                {
                     // name is ok! Must we check size?
                    if (files[j][1] != null)
                    {
                        size = test.length();
                        if (((Long)files[j][1]).longValue() != size)
                        {
                            // wrong file size. Dont go furter!
                            result = false;
                            files[j][2] = _wrongSize;
                            break;
                        }
                    }

                    // Year! This file maps!
                    found = true;
                    // set the log flag
                    if (doLog == true)
                    {
                        files[j][2] = _found;
                        break;
                    }
                }
            }

            // did we found this file?
            if (found == false)
            {
                // if not, the overall result of this method is false!
                result = false;

                // if we should not log, there is no reason to prceed further!
                if (doLog == false)
                {
                    break;
                }
                else
                {
                    files[j][2] = _notFound;
                }
            }

        }
        return result;
    }


    /**
     * Handles lost focus for the file text field.
     *
     */
    private void textLostFocus ()
    {
        // check, if the file is valid for the filter:
        _actual = new File (fileTextField.getText());

        // check existance and file filter acceptance first:
        if (_actual.exists() &&
            ((_fileFilter==null && _actual.isDirectory()) ||
             !_actual.isDirectory() && _fileFilter.accept(_actual)) /*&&
            _selection.service.doTest(_actual,_selection.index)*/)
        {
            // accepted:
            startButton.setEnabled(true);
        }
        else
        {
            startButton.setEnabled(false);
        }

    }

    /**
     * The file chooser for the browsing dialog.
     *
     * The FileFilter used in swing has additionaly a description,
     * so we need a wrapper class around our java.io.FileChooser.
     */
    private class ImportFileFilter extends javax.swing.filechooser.FileFilter
    {
        /**
         * Create a new object with given java.io.FileFilter
         *
         * @param filter The filter that does the work.
         */
        public ImportFileFilter (FileFilter filter,String desc)
        {
            _filter = filter;
            _desc = desc;
        }

        /** Not allowed. */
        private ImportFileFilter () {}

        /**
         * Checks, if a file is accepted.
         *
         * This method let the _filter work!
         *
         * @param f The file to test.
         * @return true, if the file is accepted.
         */
        public boolean accept(File f)
        {
            return !f.isFile() || _filter.accept (f);
        }

        /**
         * Returns the description of this filter.
         *
         * @return The filter description.
         */
        public String getDescription()
        {
            return _desc;
        }

        /** The filter that does the work. */
        private FileFilter _filter;

        /** The description of this filter. */
        private String _desc;
    }


    private void doBrowse ()
    {
        // gets the actual selected file/path
        _actual = new File (fileTextField.getText());

        // file chooser:
        JFileChooser choose = new JFileChooser(_actual.toString());

        // use displayed name from the combobox as dialog title:
        choose.setMultiSelectionEnabled (false);

        // Are we looking for a file or a path:
        if (_fileFilter == null)
        {
            choose.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            choose.setDialogTitle ((String)_context.translate("IDS_browse_path"));
        }
        else
        {
            choose.setFileSelectionMode(JFileChooser.FILES_ONLY);
            choose.setDialogTitle ((String)_context.translate("IDS_browse_file"));
            choose.setFileFilter(new ImportFileFilter(_fileFilter,
                ((String)((LangComboBoxModel)selectFilter.getModel ()).getSelectedItem())));
        }

        if (choose.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
        {
            _actual = choose.getSelectedFile();

            fileTextField.setText(_actual.toString());

            // enable/disable start button
            textLostFocus ();
        }
    }

    /**
     * Handle the selection of a new filter.
     *
     * @param e The event that trigger the selection, could be null
     */
    void filterSelected (ActionEvent e)
    {
        // get key of selected item:
        String key = (String)((LangComboBoxModel)selectFilter.getModel ()).getLangSelectedItem();

        if (key == null)
            return;

        // get the corresponding Data object
        _selection = (Data)importServices.get(key);

        _fileFilter = _selection.service.getFileFilter(_selection.index);

        // update file selection text
        if (_fileFilter == null)
            fileInputLabel.setText("IDS_selectPath");
        else
            fileInputLabel.setText("IDS_selectFile");

        // update description to this filter
        infoPane.setText(_selection.service.getDesription()[_selection.index]);

        Object o = getTopLevelAncestor ();

        // enable/disable start button
        textLostFocus ();

        if (o instanceof Window)
        {
            Window w = (Window)o;
            w.pack ();
            w.validate();
        }
    }

    /** Reference to mark found files. */
    private static final String _found = "IDS_Found";
    /** Reference to mark found files that have the wrong size. */
    private static final String _wrongSize = "IDS_WrongSize";
    /** Reference to mark not founded files. */
    private static final String _notFound = "IDS_NotFound";

    /** The actual selected file or path. */
    private File _actual;

    /** Contains the list of import filters. */
    private Map importServices = new HashMap ();

    /** The Data object of the actual selection. */
    private Data _selection;

    /** The actual file filter. */
    private FileFilter _fileFilter;

    /** The context this service runs in.  */
    private ServiceContext _context;

    /** The window service we belong to. */
    private WindowService _windowService;

}



