package de.jbible.service.JBibleTextProvider;

import de.jbible.core.*;
import de.jbible.bible.*;
import java.io.*;
import java.util.*;
import java.lang.ref.*;

/**
 * Bible Text Provider for the JBible bible text format.
 */

public class JBibleTextProvider extends DefaultService
	implements BibleTextProviderService
{

	/**
     * Create a new provider service.
     */
	public JBibleTextProvider()
	{
	}

    /**
     * Update the file and the title list.
     *
     * This object has a file list that contains all
     * files in the repository. And there is a title
     * array that contains all titles of the known
     * files. Both arrays are corresponding.
     */
	private void updateRepositoryLists ()
    {
    	// Read all bible files
        File filter = new File(
            	ServiceManager.getStaticProperty("BIBLEPATH"));

        _repositoryFiles = filter.listFiles(new FileFilter (){
        	public boolean accept (File f)
            { return f.getName().endsWith (".jbible"); }});

        if (_repositoryFiles == null)
			return; // emty repository
                    	
        // Create Title array:
		_repositoryTitles = new String [_repositoryFiles.length];
        _refs = new WeakReference[_repositoryFiles.length];

        // the titles are cached in the properties of this
        // service, if we cant find it there, we must load the
        // whole file!

        String key;
        BibleText bt;

        // fill title array:
        for (int i=0;i<_repositoryFiles.length;i++)
        {
        	key = "TITLE_"+_repositoryFiles[i].getName();
			_repositoryTitles[i] = _context.getProperty(key);

            if (_repositoryTitles[i] == null ||
            	"".equals(_repositoryTitles[i]))
            {
            	bt = getBible (i);

                if (bt != null)
                {
					_repositoryTitles[i] = bt.getTitle();
        	        bt = null; // forget it quick!
            	    _context.setProperty(key,_repositoryTitles[i]);
                }
            }

        }
	}

	/**
     * Index to the title of this translation.
     *
     * This is an index to the sentence list.
     *
     * @return The title index.
     */
 	public String[] getTitles()
	{
		return _repositoryTitles;
	}

    /**
     * Returns a bible.
     *
     * The request number correspondes to the order
     * of the array retured from the getTitles() method.
     *
     * @param index The index of the requested bible.
     * @return The requested bible.
     * @see #getTitles
     * @exception IndexOutOfBounds The index is not valid.
     */
	public BibleText getBible(int index)
    	throws IndexOutOfBoundsException
	{
        BibleText bt=null;

    	if (_refs[index] != null)
        {
        	bt = (BibleText)_refs[index].get();
            if (bt != null)
            	return bt;
        }

		bt = load (_repositoryFiles[index]);

		// Create weak ref:
        _refs[index] = new WeakReference (bt);


//        tests (bt);


        return bt;

	}


    /**
     * Several tests, should be moved to the JUnit framework
     * as far as we can import a free te
     */
	public void tests (BibleText bt)
    {
		byte books[] = bt.getBooks();
        int chapterCount,versCount;
        List lst;
        int i,j,k,l;
        String s;

        System.out.println("Title:"+bt.getTitle());
        //System.out.println("Copyright:"+bt.getCopyright());

        // print books:
        for (i=0;i<books.length;i++)
//        for (i = books.length-1;i >=0;i--)
        {
        	System.out.println("Book: "+Utilities.getBookName(books[i])+
            	" Title:"+bt.getBookTitle(books[i]));

            // Chapter size:
            chapterCount = bt.getChapterCount(books[i]);
            System.out.println("Chapter count:"+
            	chapterCount);

    		for (j=0;j<chapterCount;j++)
            {
				versCount = bt.getVersCount(books[i],j);
                System.out.println("Vers count:"+versCount);

                for (k=0;k<versCount;k++)
                {
	                lst = bt.getVersStrings(books[i],(byte)j,(byte)k);
                    s = "";
                    for (l=0;l<lst.size();l++)
                    	s += ((String)lst.get(l)) + " ";

             		System.out.println("Vers "+k+":"+s);
                }
            }
        }

        System.exit(0);

    }


    /**
     * Load a jbible text object.
     *
     * @param filename The name of the file to load.
     */
	private BibleText load (File filename)
    {
    	InputStream in=null;
        try
        {
        	in = new FileInputStream (filename);

            return new JBibleText (in);

        }
        catch (IOException x)
        {
        	LoggingManager.error("Try to load "+filename,x,this);
            return null;
        }
        finally
        {
        	if (in != null)
            {
                try
                {
                	in.close();
                }
                catch (IOException x)
                {
                    LoggingManager.error("Try to close stream "+filename,x,this);
                }
            }
        }
    }

	public void init(ServiceContext context)
	{
		super.init(context);
       	// update the file list and the title list:
		updateRepositoryLists ();
		context.registerTitle("Textprovider for the native JBible text format.");

	}

	public void start()
	{
		//TODO: implement this de.jbible.core.Service method;
	}

	public void exit()
	{
		//TODO: implement this de.jbible.core.Service method;
	}

    /**
     * Array of all known files in the repository.
     */
	private File [] _repositoryFiles;

    /**
     * Array of all titles of the repository files.
     */
    private String [] _repositoryTitles;


    /**
     * Weak References to loaded bibles.
     */
    private WeakReference [] _refs;

}