package de.jbible.service.JBibleTextProvider;

import java.io.*;
import java.util.*;

/**
 * Represents the String array of a bible.
 *
 * The whole data is read once from stream.
 * After that strings are converted if needed.
 */
public class StringArray
{
	/**
     * Create and load a new string array,
     *
     * @param in The input Stream
     * @exception IOException An reading error occured.
     */
	public StringArray(DataInputStream in)
    	throws IOException
	{
    	// Read all strings up to the empty string:
        int size = in.readInt();
        int count = in.readInt();
        _buffer = new byte [size];
        _strings = new String [count];
        in.read(_buffer);
	}

    /**
     * Access a string from the array.
     *
     * @param index The index of the string.
     * @return The string.
     */
    public String get (int index)
    {
    	index--;
    	if (_strings[index] == null)
        {
        	_strings[index] = readString (index);
        	_read++;
        	if (_read == _strings.length)
            	_buffer = null; // each string is converted, we dont need the buffer any longer
        }

        return _strings[index];
    }



    /**
     * Read a UTF8 string and convert it.
     *
     * @param index The position of the string.
     * @return The string.
     */
	private String readString (int index)
    {
    	int pos = 0;

        // find pos:
        for (pos=0;pos<_buffer.length && index > 0;pos++)
        {
        	if (_buffer[pos] == 32)
            	index--;
        }

		StringBuffer buf = new StringBuffer ();

        int x,y,z;
        char data;

        do
        {
        	// read data
        	x = _buffer [pos++];
            if ((x & 0x80) == 0x80)
            {
            	// more then one byte!
            	if ((x & 0xe0) == 0xc0)
                {
                    // two bytes!
		        	y = _buffer [pos++];
                    data = (char) (((x & 0x1f) << 6) + (y & 0x3f));


                }
                else if ((x & 0xf0) == 0xe0)
                {
                	// three bytes!
                	y = _buffer [pos++];
		        	z = _buffer [pos++];
                    data = (char)(((x & 0xf)<<12)+((y & 0x3f) << 6) + (z & 0x3f));
                }
                else
                	throw new IndexOutOfBoundsException ("Wrong starting position"+pos);
            }
            else
            {
            	data = (char)x;
            }

            if (data == 32)
            	break;

            buf.append(data);
        } while (pos < _buffer.length);

	    return buf.toString();
    }

    /**
     * Return the count of strings.
     *
     * @return The count of strings.
     */
	public int size ()
    {
    	return _strings.length;
    }

    /**
     * The strings as array of bytes. The strings
     * are separated by space (32).
     */
    private byte [] _buffer;

    /**
     * The strings in normal java form.
     */
	private String [] _strings;

    /**
     * Counts the read strings. If all strings are read,
     * we can get rid of the buffer.
     */
    private int _read = 0;
}