package de.jbible.service.MainWindow;

import java.awt.*;
import java.io.*;
import de.jbible.core.*;
import javax.swing.*;
import javax.swing.text.*;
import de.jbible.tool.swinglang.*;
import de.jbible.tool.swingmisc.*;

/**
 * This panel implements a progress window for the Swing MainWindowService.
 *
 */
public class ProgressPanel extends JPanel implements ProgressWindowInterface
{
    /** The main and only layout. */
    private BorderLayout mainLayout = new BorderLayout();
    /** Displays the logs. */
    private JTextArea logArea = new JTextArea();

    /** The progress bar. */
    private JProgressBar progressBar = new JProgressBar();

    /** Scroll pane for the logging area. */
    private JScrollPane logAreaScrollPane = new JScrollPane();

    /** Not allowed! */
    private ProgressPanel() {}

    /**
     * Create a new object with the given context.
     */
    public ProgressPanel(ServiceContext context)
    {
        _context = context;
        try
        {
            jbInit();
        }
        catch(Exception ex)
        {
            LoggingManager.error("Create ProgressPanel",ex,this);
        }
    }

    private void jbInit() throws Exception
    {
        this.setLayout(mainLayout);
        this.add(progressBar, BorderLayout.SOUTH);
        this.add(logAreaScrollPane, BorderLayout.CENTER);
        logAreaScrollPane.getViewport().add(logArea, null);
  }

    /**
     * The user of the interface must call this method if the
     * action has finished.
     *
     * The facility can now display a close button instead of a progress bar.
     */
    public void finished()
    {
        // remove the bar and create a finish button:
        remove(progressBar);
        JPanel buttonPanel = new JPanel ();
        JButton close = new LangJButton (_context);
        close.setText("MW_close");
        close.addActionListener(new CloseJInternalFrameActionListener());
        buttonPanel.add(close);
        add (buttonPanel,BorderLayout.SOUTH);
        getParent().validate();

        // scroll to the bottom:
        scrollToBottom ();
    }

   /**
     * Update the progress bar.
     *
     * @param percent The actual percentage of progress.
     */
    public void setProgressValue(int percent)
    {
        progressBar.setValue(percent);
    }

    /**
     * Log a message.
     *
     * This could be a message, a warning or a error. The state give the
     * facility the opportunity to use different colors. Valid states are
     * {@link de.jbible.core.ProgressWindowInterface#WARNING WARNING}
     * {@link de.jbible.core.ProgressWindowInterface#MESSAGE MESSAGE}
     * {@link de.jbible.core.ProgressWindowInterface#ERROR ERROR}
     *
     * @param msg The message to log
     */
     public void logMessage(String msg, int state)
    {
        switch (state)
        {
            case ProgressWindowInterface.ERROR :
                msg = "Error: " + msg +"\n";
                break;
            case ProgressWindowInterface.WARNING :
                msg = "Warning: " + msg+"\n";
                break;
            case ProgressWindowInterface.MESSAGE :
                msg += "\n";
                break;
            default :
                LoggingManager.error("Invalid message state:"+state,this);
                break;
        }

        logArea.append(msg);

        scrollToBottom ();
    }

    /**
     * Scroll to the bottom of the scroll area.
     *
     */
    private void scrollToBottom ()
    {
        Rectangle r = logArea.getBounds();
        JViewport vport = logAreaScrollPane.getViewport();
        Dimension d = vport.getSize();
        vport.scrollRectToVisible(new Rectangle (
            r.x+r.width-d.width,
            r.y+r.height-d.height,
            d.width,
            d.height));
    }

    /** The service context. */
    private transient ServiceContext _context;

}