//PalmTextProvider.java

package de.jbible.service.PalmTextProvider;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import de.jbible.core.*;
import de.jbible.tool.swinglang.*;
import de.jbible.tool.swingmisc.*;


/**
 * This service provides a dialog for communication with
 * a Palm Device.
 */


public class PalmTextProvider extends DefaultService implements Service
{
    /**
     * Init: Gets all Palm Services from the manager.
     * Registers this service in all window services
     *
     * @param context The context of the service
     */
    public void init(ServiceContext context)
    {
        super.init(context);

        // register name and resource bundle:
        context.registerTitle("Palm Text Provider Service");
        context.registerResourceBundle("de.jbible.service.PalmTextProvider.PalmTextProviderResourceBundle");
    }

    /**
     * Start: Register service into all window services.
     */
    public void start ()
    {
        //get all services that implements WindowServices
        //and put it in a list - at the moment just MainWindow

        java.util.List serv = _context.getServices (de.jbible.core.WindowService.class);


        //iterate over all WindowServices

        if (serv != null)
        {
            Iterator winServices = serv.iterator();
            WindowService ws; //handle of a WindowService

            while (winServices.hasNext())
            {
                ws = (WindowService)winServices.next();

                try
                {
                 //register PalmTextProvider service into WindowService (MainWindow)
                 ws.registerAction
                 (
                  "IDS_PalmTextProvider",            /* name in window-menue */
                  WindowService.GRP_TOOLS,           /* menue-group fr name */
                  new ServiceActionListener (ws)     /* handle to ActionListener */
                  {
                   public void actionPerformed (ActionEvent e) /* create service dialog */
                    {
                     createPalmTextProviderDialog ((WindowService)_service,e);
                    }
                  },
                  _icon,                              /* icon of the service */
                  "IDS_PalmTextProvider_desc");       /* text for tool-tip */
                }
                catch (IllegalGroupException ex)
                {
                    ex.printStackTrace();
                }                         
            }
        }
        else
        {
        }
    }


    /**
     * Create the actual Palm Text Provider Dialog.
     *
     * @param event The event that has occured
     */
    private void createPalmTextProviderDialog (WindowService ws,ActionEvent event)
    {
        // create an object of the actual panel of the dialog
        JPanel basePanel;
        basePanel= new PalmTextProviderDialogPanel (_context, ws);

        // create a dialog window with the basePanel in it
        Window win = ws.createDialog("IDS_PalmTextProvider",basePanel,_icon);

        //complete it
        win.pack();
        win.validate();
        win.setVisible (true);
    }


    /** The Icon of this service. */
    //...stimmt noch nicht
    static final String _icon = "de/jbible/service/PalmTextProvider/Palm.gif";

}

