//PalmTextProviderDialogPanel.java

package de.jbible.service.PalmTextProvider;

import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.util.*;

import de.jbible.core.*;
import de.jbible.tool.swinglang.*;
import de.jbible.tool.swingmisc.*;
import de.jbible.service.JBibleTextProvider.*;

/**
 * Main dialog for the Palm Text Provider Service.
 */
public class PalmTextProviderDialogPanel extends JPanel {

  BorderLayout borderLayout;
  GridLayout gridLayout;

  JPanel selectPanel;
  JPanel buttonPanel;

  LangJLabel select_bibleLabel;
  LangJComboBox select_bibleList;
  LangComboBoxModel model;
  LangJButton okButton;
  LangJButton cancelButton;

  BibleTextProviderService TextProvider; /* Provider Appl. */


  /**
   * Select the Bible-Version you want to have for the Palm-Device.
   *
   * @param context To connect with the ResourceBundle.
   */
  public PalmTextProviderDialogPanel(ServiceContext context, WindowService ws) {
    try  {
      _context = context;
      _windowService = ws;

      Init();
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }
  }


  /**
   * Initialize and build the dialog
   */
  private void Init() throws Exception {

    // Create all the objects needed for the dialog

    borderLayout = new BorderLayout();
    gridLayout = new GridLayout();
    selectPanel = new JPanel();
    buttonPanel = new JPanel();
    select_bibleLabel = new LangJLabel(_context);
    select_bibleList = new LangJComboBox(_context);
    model = (LangComboBoxModel)select_bibleList.getModel ();
    okButton = new LangJButton(_context);
    cancelButton = new LangJButton(_context);

        // get all BibleImportFilters
    java.util.List provider = _context.getServices(de.jbible.core.BibleTextProviderService.class);

    // register this service in all window services:

    if (provider != null)
    {
        ListIterator li = provider.listIterator ();

        while (li.hasNext())
        {
            TextProvider = (BibleTextProviderService)li.next();
            break;
        }
    }


    // Specify the components

    this.setLayout(borderLayout);
    selectPanel.setLayout(gridLayout);
//  buttonPanel.setLayout(borderLayout); /* default */

    select_bibleLabel.setText("IDS_SelectBibleVersion");

    /* get all the available Bible-Versions */
    /* and put it in the List */
//    TextProvider.start(); /* start the application */


    String[] titles = TextProvider.getTitles(); //irgendwie falsch ??????????
    /* Fehlerersetzung (...)*/
//    String[] titles = {"Luther","Elberfelder","Sonstige"}; //hiermit funktioniert es

    for (int i=0; i < titles.length; i++) {
     model.addElement(titles[i]);
    }

    okButton.setText("IDS_OK");
    okButton.addActionListener(new ActionListener () {
     public void actionPerformed(ActionEvent e){

      /* ------------------------------------- */
      /* Testausgabe */
      /* ------------------------------------- */
      int bibleIndex = select_bibleList.getSelectedIndex();
      _BibleText = TextProvider.getBible(bibleIndex);
      byte[] books = _BibleText.getBooks();
      java.util.List vers = _BibleText.getVersStrings(books[0], 1, 1);
      for (int i=0; i<vers.size(); i++)
       model.addElement( vers.get(i).toString() ); //Aktualisierung der Liste ??????????
      /* ------------------------------------- */
      /* ------------------------------------- */
     }});

    cancelButton.setText("IDS_Cancel");
    cancelButton.addActionListener(new CloseDialogActionListener ());


    // Put the components together

    this.add(selectPanel, BorderLayout.NORTH);
    selectPanel.add(select_bibleLabel, null);
    selectPanel.add(select_bibleList, null);
    this.add(buttonPanel, BorderLayout.SOUTH);
    buttonPanel.add(okButton, null);
    buttonPanel.add(cancelButton, null);

  }


  /** The context this service runs in.  */
  private ServiceContext _context;

  /** The window service we belong to. */
  private WindowService _windowService;

  /** The Bible selected from the user.  */
  private BibleText _BibleText;

}



