package de.jbible.test.bible;

import junit.framework.*;
import de.jbible.bible.*;
import java.lang.reflect.*;

public class BibleBooksTest  extends TestCase
{
	public BibleBooksTest(String name) {
		super(name);
	}

    /**
     * Test, if no const value is used twice.
     */
    public void testBookConstIntegrity ()
    {
    	int i,j,k,l;
        byte value;

        // iterate over all sub arrays for value:
        for (i=0;i<allConsts.length;i++)
        {
			// iterate over subarray for value:
            for (j=0;j<allConsts[i].length;j++)
            {
            	value = allConsts [i][j];

                // search this value in the rest of the arrays:

                // iterate over sub arrays for comparing:
                for (k=i;k<allConsts.length;k++)
                {
                	if (k==i)
                    	l =j+1;
                    else
                    	l = 0;
                    // iterate over subarray for comparing:
                    for (;l<allConsts[k].length;l++)
                    {
                    	assert ("\n\tCompare ("+i+","+j+") with ("+k+","+l+") Value: "+value,
	                        value != allConsts[k][l]);
                    }
                }
            }
        }

    }

    /**
     * Test correctness of debug defines
     */

	public void testDebugDefines ()
    	throws Exception
    {
		int i,j,k;
        String name;
        byte value;
        boolean found;
        Class books = de.jbible.bible.BibleBooks.class;
        Field[] fields = books.getFields();



        // iterate over all names:
        for (i=0;i<allConsts.length;i++)
        {
        	// check length of arrays:
            assert (allConsts[i].length == allNames[i].length);

            for (j=0;j<allConsts[i].length;j++)
            {
            	value = allConsts [i][j];
                name = allNames [i][j];

                // refelct the variable with the name "name"
                // and compare it with value:
                found = false;
                for (k=0;k<fields.length;k++)
                {
                	if (fields[k].getName().equals(name))
                    {
                    	// compare value:
                        assert (fields[k].getByte(null) == value);

                        // check data type:
                        assert (fields[k].getModifiers() ==
                        	(Modifier.FINAL | Modifier.PUBLIC | Modifier.STATIC));
                        assert (fields[k].getType() == byte.class);

                    	found = true;
                    }
                }


            	assert (found);

        	}
        }
    }

    private static final byte[][] allConsts =
    	{ 	BibleBooks.OldTestamentBooks,
        	BibleBooks.NewTestamentBooks,
            BibleBooks.ApocryphaBooks,
            BibleBooks.Parts };

    private static final String[][] allNames =
    	{ 	BibleBooks.OldTestamentBookNames,
        	BibleBooks.NewTestamentBookNames,
            BibleBooks.ApocryphaBookNames,
            BibleBooks.PartNames };

}
