package de.jbible.test.service.JBibleTextProvider;

import junit.framework.*;
import de.jbible.tool.bibleimport.*;
import de.jbible.service.JBibleTextProvider.*;
import java.io.*;

public class IndexListTest  extends TestCase
{
	public IndexListTest(String name) {
		super(name);
	}

    /**
     * Test Read/Write consistency.
     */
    public void testReadWrite ()
    	throws IOException
    {
    	for (float f=(float)1;f<65565;f *= Math.PI)
        {
			// Create test stream:
    	    IndexListWriter ilw = new IndexListWriter ();
        	fillList (ilw,f);

            // write list
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream (bout);
            ilw.write(out);

            // ilw is now internal half destroyed, and there
            // is no way to restore it. This is ugly, but neccessary
            // for memory reasons. This means for comparison
            // that we must create in new :-(
    	    IndexListWriter ilw2 = new IndexListWriter ();
        	fillList (ilw2,f);

            bout.flush();
            byte [] data = bout.toByteArray();

            // Read again:
            DataInputStream in = new DataInputStream (
               	new ByteArrayInputStream (data));

            IndexList il = new IndexList (in,false);
	// test with uncompressd data
            // compare read list with written list:
            assert ("Run1: Compare size run "+f,ilw.size() == il.size());
            for (int i=0;i<ilw2.size();i++)
            	assert ("Run1: Compare value "+i+" in run "+f,
                	ilw2.getValue(i) == il.getFromPosition(ilw.mapIndex(i)));

            // Read again:
            in = new DataInputStream (
               	new ByteArrayInputStream (data));

            il = new IndexList (in,true);
	// test with compressed data
            // compare read list with written list:
            assert ("Run2: Compare size run "+f,ilw.size() == il.size());
            for (int i=0;i<ilw2.size();i++)
            	assert ("Run2: Compare value "+i+" in run "+f,
                	ilw2.getValue(i) == il.getFromIndex(i));
        }
    }

        /**
     * Fill list with test data.
     *
     * The test data are in the range from 0 to 255. But you
     * can specify a factor to get bigger values.
     *
     * @param list The list to fill.
     * @param factor The factor for the values.
     */
	private void fillList (IndexListWriter list,float factor)
    {
		for (int i=255;i>=0;i--)
        	list.addEntry((int)(((float)i)*factor));
    }
}
