package de.jbible.test.service.JBibleTextProvider;

import junit.framework.*;
import de.jbible.tool.bibleimport.*;
import de.jbible.service.JBibleTextProvider.*;
import java.io.*;
import java.util.*;

public class StringArrayTest  extends TestCase
{
	public StringArrayTest(String name) {
		super(name);
	}

    /**
     * Test Read/Write consistency.
     */
    public void testReadWrite ()
    	throws IOException
    {
    	// Create string pool:
        StringPool sp = new StringPool ();
        fillPool (sp);
		List lst = sp.sort();
        // write pool:

        ByteArrayOutputStream bos = new ByteArrayOutputStream ();
        DataOutputStream dos = new DataOutputStream (bos);
        sp.write(dos);
        dos.flush();


        // get data
        byte [] data = bos.toByteArray();

        // Read again:
        DataInputStream dis = new DataInputStream (
        	new ByteArrayInputStream (data));

        StringArray arr = new StringArray (dis);
        StringPoolData dat;
        String c1,c2;

        assert ("Compare the size of read and written string array.",
        	sp.size () == arr.size());

        // Compare results:
        for (int i =0;i<lst.size();i++)
        {
        	dat = (StringPoolData)lst.get(i);
            c1 =  dat.getString();
            c2 = arr.get(i+1);
        	assert ("Compare position "+i+": "+
            	c1+" == "+c2,c1.equals(c2));
        }





    }

        /**
     * Fill a string pool with some data:
     */
    private void fillPool (StringPool p)
    {
    	int i,j;

        for (i=testData.length-1;i>=0;i--)
        {
        	for (j=0;j<=i;j++)
            	p.add (testData[i]);
        }
    }

    /** Set of test data */
    private static final String []testData = {
    	"Dies","sind","Testdaten",",","Nur","zum",
        "testen","!","\n","\u00f6\u00e4\u00df\u00fc\u00d6\u00c4\u00dc\u00e1\u00e9\u00ed\u020b",
        "\u8000\u9001\u9002",
        "\uffff\uf0f0\u0f0f\u5050\u0505\ua0a0\u0a0a",
        "\u0805\u0850\u08a0\u080a",
        };


}
