package de.jbible.test.tool.bibleimport;

import junit.framework.*;
import java.io.*;
import java.util.*;
import de.jbible.tool.bibleimport.*;
import de.jbible.service.JBibleTextProvider.*;

/**
 * Test class for the DefaultIndexList
 */

public class IndexListWriterTest extends TestCase
{
	public IndexListWriterTest(String name) {
		super(name);
	}

    /**
     * Test storage behaviour of list.
     */
	public void testStorage ()
    {
    	IndexListWriter dlx = new IndexListWriter ();

        // fill list with test data
        fillList (dlx,1);

        int j=0;
        // test if test data are in:
		for (int i=0;i<256;i++)
        	assert (dlx.getValue(j++) ==i);
    }

    /**
     * Test memory consume calculation.
     */
	public void testMemCalc ()
    	throws IOException
    {
    	IndexListWriter dlx;
        short result;
        DataOutputStream out;

        dlx = new IndexListWriter ();
        fillList (dlx,65536);
        result = dlx.computeOptimizeStorage();
        assert (result== (IndexList.TRIPPLE_BYTE));
        out = new DataOutputStream(new ByteArrayOutputStream ());
        dlx.write(out);

        dlx = new IndexListWriter ();
        fillList (dlx,16777216);
        result = dlx.computeOptimizeStorage();
        assert (result== (IndexList.QUAD_BYTE|IndexList.FOLLOW_FLAG_BIT1));
        out = new DataOutputStream(new ByteArrayOutputStream ());
        dlx.write(out);

        dlx = new IndexListWriter ();
        fillList (dlx,256);
        result = dlx.computeOptimizeStorage();
        assert (result== (IndexList.DOUBLE_BYTE));
        out = new DataOutputStream(new ByteArrayOutputStream ());
        dlx.write(out);

        dlx = new IndexListWriter ();
        fillList (dlx,2);
        result = dlx.computeOptimizeStorage();
        assert (result== (IndexList.DOUBLE_BYTE|IndexList.FOLLOW_FLAG_BIT1));
        out = new DataOutputStream(new ByteArrayOutputStream ());
        dlx.write(out);


        dlx = new IndexListWriter ();
        fillList (dlx,1);
        result = dlx.computeOptimizeStorage();
        assert (result==IndexList.SINGLE_BYTE);
        out = new DataOutputStream(new ByteArrayOutputStream ());
        dlx.write(out);


    }


    /**
     * Fill list with test data.
     *
     * The test data are in the range from 0 to 255. But you
     * can specify a factor to get bigger values.
     *
     * @param list The list to fill.
     * @param factor The factor for the values.
     */
	private void fillList (IndexListWriter list,float factor)
    {
		for (int i=0;i<256;i++)
        	list.addEntry((int)(((float)i)*factor));
    }

}