package de.jbible.test.tool.bibleimport;

import junit.framework.*;
import de.jbible.tool.bibleimport.*;
import java.io.*;
import java.util.*;

/**
 * Test case for StringPool.
 */
public class StringPoolTest extends TestCase
{

	public StringPoolTest(String name) {
		super(name);
	}

   
    /**
     * Test add method of string pool.
     */
    public void testAdd ()
    {
    	StringPool s = new StringPool ();
        String s1 = "Hallo";
        String s2 = "Hallo";
        String s3 = "Du";
        String s4 = "Du";

        assert (s.add(s1) == s1);
        assert (s.add(s3) == s3);
        assert (s.add(s2) == s1);
        assert (s.add(s4) == s3);
        assert (s.add(s1) == s1);
        assert (s.add(s3) == s3);
    }

    /**
     * Test add method of string pool.
     */
    public void testNormalize()
    {
    	StringPool s = new StringPool ();
        String s1 = "Hallo";
        String s2 = "Hallo";
        String s3 = "Du";
        String s4 = "Du";
        String s5 = "unknown";

        assert (s.add(s1) == s1);
        assert (s.add(s3) == s3);
        assert (s.normalize(s1) == s1);
        assert (s.normalize(s2) == s1);
        assert (s.normalize(s3) == s3);
        assert (s.normalize(s4) == s4);
        assert (s.normalize(s5) == s5);
    }

    /**
     * Test sort method.
     */
	public void testSorting ()
    {
    	StringPool s = new StringPool ();

        // fill with data:
        fillPool (s);
        List l = s.sort ();

        Iterator iter = l.iterator();
        StringPoolData data;

        // check order
        for (int i=0;i<testData.length;i++)
        {
        	// get next item from list:
        	assert (iter.hasNext());
            data = (StringPoolData)iter.next();

            // check data object:
            assert (data.getString() == testData[testData.length-i-1]);

            // check order
            assert (s.getOrder(testData[i]) == testData.length-i-1);
        }
    }

    /**
     * Fill a string pool with some data:
     */
    private void fillPool (StringPool p)
    {
    	int i,j;

        for (i=testData.length-1;i>=0;i--)
        {
        	for (j=0;j<=i;j++)
            	p.add (testData[i]);
        }
    }

    /** Set of test data */
    private static final String []testData = {
    	"Dies","sind","Testdaten",",","Nur","zum",
        "testen","!","\n","\u00f6\u00e4\u00df\u00fc\u00d6\u00c4\u00dc\u00e1\u00e9\u00ed\u020b"};

}
