package de.jbible.tool.bibleimport;

/**
 * This visitor creates the string pool
 * for a bible translation and do some
 * statistcs that are neccessary to decide
 * the optimal storage of the translation.
 */

public class AnalyseVisitor implements Visitor
{

	/**
     * Count books.
     */
	public int visitBook(Book book)
	{
    	_bookCount++;

        return CONTINUE;
	}

    /**
     * Count chapters.
     */
	public int visitChapter(Chapter chapter)
	{
    	_chapterCount++;
        return CONTINUE;
	}

    /**
     * Count verses.
     */
	public int visitVers(Vers vers)
	{
    	_versCount++;
        return CONTINUE;
	}

    /** Not needed here. */
	public int visitSentence(Sentence sentence)
    {
    	return CONTINUE;
    }

    /**
     * Count words and add word to string pool.
     */
	public int visitWord(Word word)
	{
    	_wordCount++;
        // add word to pool:
        word.setWord(_pool.add(word.getWord()));
        return Visitor.NO_CHILDS;
	}

    /** Not used jet. */
  	public int visitBibleWord (Word word)
    {
        return CONTINUE;
    }

    /** Not used jet. */
	public int visitMetaInfo(MetaInfo metainfo)
    {
        return CONTINUE;
    }

    /**
     * Access to the string pool.
     *
     * @return The string pool.
     */
	public StringPool getStringPool ()
    {
    	return _pool;
    }

    public String toString()
    {
    	return 	"Books: "+_bookCount +
                "\nChapters: "+ _chapterCount +
                "\nVerses: "+_versCount +
                "\nWords: "+_wordCount+
                "\n"+_pool;
    }


    /**
     * The string pool that is created by this visitor.
     */
    private StringPool _pool = new StringPool();

    /** Count of books. */
    private int _bookCount = 0;

    /** Count of chapters. */
    private int _chapterCount = 0;

    /** Count of verses. */
    private int _versCount = 0;

    /** Total count of words. */
    private int _wordCount = 0;

}
