package de.jbible.tool.bibleimport;

import java.util.*;

/**
 * Object represents a Chapter.
 *
 * A chapter is a list of verses with optional meta informations.
 */


public class Chapter extends MetaInfoContainer  
{

    /** Dont used it. */
	private Chapter() { 	super (null);}

    /**
     * Create a new object with given number and verses.
     *
     * The verses are a linked list. The list will be destroyed
     * and the objects will be added to the internal list.
     *
     * @param number The number of this chapter
     * @param verses One or more verses, linked internally together.
     * @param meta Metainfo of this chapter
     */
    public Chapter (String number,Vers verses,MetaInfo meta)
    {
    	super (meta);
		_number = Integer.parseInt(number);
        Debug._chapterNr = _number;

        addVerses (verses);
    }

    /**
     * Create a new object with given number and verses.
     *
     * The verses are a linked list. The list will be destroyed
     * and the objects will be added to the internal list.
     *
     * @param number The number of this chapter
     * @param verses One or more verses, linked internally together.
     * @param meta Metainfo of this chapter
     * @param next The next chapter, internal linkage.
     */
    public Chapter (String number,Vers verses,MetaInfo meta,Chapter next)
    {
    	this (number,verses,meta);
        _next = next;
    }

    /**
     * Add vers(es) to this object.
     *
     * @param verses The meta info(s) to add. It can be one
     *		or more, with the next ref internally linked together.
     *		Each element on its own is added to the internal list.
     *		The next param will be set to null.
     */
    public void addVerses (Vers verses)
    {
    	if (verses == null)
        	return;
            
    	if (_verses == null)
        	_verses = new LinkedList ();

    	Vers next;
    	do
        {
        	_verses.add(verses);
            next = verses._next;
            verses._next = null;
            verses = next;

        }
        while (verses != null);
    }

	/**
     * Access the vers list.
     *
     * @return The iterator over all verses, can be null.
     */
	public Iterator getVerses ()
    {
    	if (_verses == null)
        	return null;

    	return _verses.iterator();
    }

    /**
     * Visit the whole data tree.
     *
     * @param visitor The visitor object.
     */
	public int visit (Visitor visitor)
    {
		// visit this object
    	if (visitor.visitChapter(this) != Visitor.NO_CHILDS)
		{
            // visit the MetaInformations:
            super.visit (visitor);

            // visit childs:
            if (_verses != null)
            {
	            Iterator iter = _verses.iterator();

    	        while (iter.hasNext())
        	        ((Vers)iter.next()).visit(visitor);
            }
        }
        return Visitor.CONTINUE;

    }

    /**
     * Debuging purpose.
     *
     * @return A string that describes this object.
     */
    public String toString ()
    {
    	return "Chapter "+_number;
    }

    /** Number of this vers. */
    private int _number;

    /** List of verses. */
    private List _verses ;

    /** Ref to next Chapter, internal linkage. */
    transient Chapter _next;
}



