package de.jbible.tool.bibleimport;

/**
 * For debug purpose only.
 *
 * It writes methods to stdout for each visited object.
 */
public class DebugVisitor implements Visitor
{

	/** Log that we visit this object. */
	public int visitBook(Book book)
	{
    	System.out.println("Visit book: "+book);
        return CONTINUE;
	}

	/** Log that we visit this object. */
	public int visitChapter(Chapter chapter)
	{
    	System.out.println(" Visit chapter: "+chapter);
        return CONTINUE;
	}

	/** Log that we visit this object. */
	public int visitVers(Vers vers)
	{
    	System.out.println("  Visit vers: "+vers);
        return CONTINUE;
	}

	/** Log that we visit this object. */
	public int visitSentence(Sentence sentence)
	{
    	System.out.println("   Visit sentence "+sentence);
        return CONTINUE;
	}

	/** Log that we visit this object. */
	public int visitWord(Word word)
	{
    	System.out.println("     Visit word: "+word);
        return CONTINUE;
	}

	/** Log that we visit this object. */
	public int visitBibleWord(Word word)
	{
    	System.out.println("     Visit Bible word: "+word);
        return CONTINUE;
	}

	/** Log that we visit this object. */
	public int visitMetaInfo(MetaInfo metainfo)
	{
    	System.out.println("    Visit MetaInfo: "+metainfo);
        return CONTINUE;
	}

}
