package de.jbible.tool.bibleimport;

import de.jbible.core.*;
import java.io.*;

/**
 * Writer for the header of a jbible.text file.
 *
 */

public class HeaderWriter
{

    /**
     * Return internal stored value
     * See interface definition for details.
     */
	public int getVersion()
	{
		return _version;
	}

    /**
     * Return internal stored value
     * See interface definition for details.
     */
	public int getTitle()
	{
		return _title;
	}

    /**
     * Return internal stored value
     * See interface definition for details.
     */
	public int getCopyright()
	{
		return _copyright;
	}

    /**
     * Return internal stored value
     * See interface definition for details.
     */
	public int getCopyrightIdentifier()
	{
		return _copyrightIdentifier;
	}


    /**
     * Set the file version.
     *
     * @param version The new file version
     */
	public void setVersion(int version)
	{
		_version = version;
	}


    /**
     * Set the title index.
     *
     * @param index The new title index.
     */
	public void setTitle(int index)
	{
		_title = index;
	}

    /**
     * Set the index to the copyright notice.
     *
     * @param index The new index of the copyright notice.
     */
	public void setCopyright(int index)
	{
		_copyright = index;
	}

    /**
     * Set the copyright identifier.
     *
     * @param ident The new copyright identifier.
     */
	public void setCopyrightIdentifier(int ident)
	{
		_copyrightIdentifier = ident;
	}

    /**
     * Set the local identifier.
     *
     * @param locale The Local identifer of the version to write.
     */
    public void setLocale (int locale)
    {
    	_locale = locale;
    }


    /**
     * Debug only.
     */
    public String toString ()
    {
    	String cIdent;
        int cid = getCopyrightIdentifier();

        switch (cid & 0x0f)
        {
        	case BibleText.COPYRIGHT_PUBLICDOMAIN :
            	cIdent = "Public Domain";
                break;
            case BibleText.COPYRIGHT_SHAREWARE :
            	cIdent = "Shareware";
            	break;
            case BibleText.COPYRIGHT_BUYWARE :
            	cIdent = "Buyware";
                break;
            default :
            	cIdent = "Illegal copyright identifier.";
                break;
        }

        if ((cid & BibleText.COPYRIGHT_TOFRIENDS)!= 0)
        	cIdent = "; Give to friends.";
        if ((cid & BibleText.COPYRIGHT_WEBPUBLISH)!=0)
        	cIdent = "; Webpublish";

    	return
        	"Version: " + getVersion() +
            "\nTitle index: "+getTitle()+
            "\nCopyright idex: "+getCopyright()+
            "\nCopyright identifier"+cIdent +
            "\nLocale: "+_locale;
    }

    /**
     * Write this object to a object stream.
     *
     * @param out The output stream.
     * @exception IOException IO operation error.
	 */
	public void write (DataOutputStream out)
    	throws IOException
    {
        out.writeInt(_version);
        out.writeInt(_title);
        out.writeInt(_copyright);
        out.writeInt(_copyrightIdentifier);
        out.writeInt(_locale);
    }

    /**
     * Read this object from stream.
     *
     * @param in The input stream.
     * @exception IOException An error occures while reading.
     */
  /*	public void read (ObjectInputStream in)
    	throws IOException
    {
    	// we do not know, if the stream that we get is
        // an ObjectInputStream, so we test it and create
        // one, if we get a wrong one.
    	ObjectInputStream stream;
        if (in instanceof ObjectInputStream)
        	stream = (ObjectInputStream)in;
        else
        	stream = new ObjectInputStream (in);

        _version = stream.readInt();
        _title = stream.readInt();
        _copyright = stream.readInt();
        _copyrightIdentifier = stream.readInt();
    }*/

    /**
     * Version number of file format.
     */
    private int _version;

   /**
     * The title of this bible.
     *
     * Index of the sentence list.
     */
	private int _title;

    /*
     * The copyright notice of the bible. Could be null.
     *
     * Index of the sentence list.
     */
	private int _copyright;

    /**
     * Copyright identifer of this bible.
     */
	private int _copyrightIdentifier;

    /**
     * The Local identifier strig.
     */
	private int _locale;
}