package de.jbible.tool.bibleimport;

import java.util.*;
import java.io.*;

/**
 * Base class for objects that can contains
 * Meta Informations.
 */
public abstract class MetaInfoContainer implements Serializable
{
	/**
     * Create new object with given Meta Info.
     *
     * @param meta The meta info.
     */
	public MetaInfoContainer(MetaInfo meta)
	{
    	addMetaInfo (meta);
	}

    /** Not allowed. */
    private MetaInfoContainer () {}

    /**
     * Add MetaInfos to this object.
     *
     * @param meta The meta info(s) to add. It can be one
     *		or more, with the next ref internally linked together.
     *		Each element on its own is added to the internal list.
     *		The next param will be set to null.
     */
    public void addMetaInfo (MetaInfo meta)
    {
    	if (meta == null)
        	return ;

        if (_meta == null)
        	_meta =  new LinkedList ();

    	MetaInfo next;
    	do
        {
        	_meta.add(meta);
            next = meta._next;
            meta._next = null;
            meta = next;

        }
        while (meta != null);
    }


    /**
     * Access the optional meta informations.
     *
     * @return The meta info, can be null.
     */
	public Iterator getMetaInfo ()
    {
    	if (_meta == null)
        	return null;

    	return _meta.iterator();
    }


    /**
     * Visit this container.
     *
     * @param visitor The visitor object.
     */
	public int visit (Visitor visitor)
    {
		if (_meta != null)
		{
            Iterator iter = _meta.iterator();

            while (iter.hasNext())
                ((MetaInfo)iter.next()).visit (visitor);
		}
        return Visitor.CONTINUE;
    }

    /**
     * Debug purpose.
     *
     * @return A description of this object.
     */
    public String toString ()
    {
    	if (_meta == null)
        	return "";

    	String result = "\tMetaInfo:\n";

		Iterator iter = getMetaInfo ();

        while (iter.hasNext())
        {
        	Object o = iter.next();
        	result += "\t\t"+o;
        }

        return result;
    }

    /** The meta info. */
    private List _meta;
}
