package de.jbible.tool.bibleimport;

import java.util.*;

/**
 * Contains one sentence.
 *
 * This means a list of words.
 */
public class Sentence extends MetaInfoContainer
{
	/**
     * Create a new sentence object.
     *
     * @param firstWord The first word of the sentence
     */
	public Sentence(Word firstWord)
	{
    	super (null);
    	addWord (firstWord);
	}

	/**
     * Create a new sentence object.
     *
     * @param firstWord The first word of the sentence
     * @param meta The meta info of this object
     */
	public Sentence(Word firstWord,MetaInfo meta)
	{
    	super (meta);
    	addWord (firstWord);
	}

	/**
     * Add the next word.
     *
     * @param word The next word.
     */
    public void addWord (Word word)
    {
		_words.add(0,word);
    }

    public String toString ()
    {
    	String result = "";

        Iterator iter = getWords();

        while (iter.hasNext())
        {
        	result += ((Word)iter.next()).getWord()+" ";
        }
		return result;

    }

    /**
     * Visit the whole data tree.
     *
     * @param visitor The visitor object.
     */
	public int visit (Visitor visitor)
    {
		// visit this object
    	if(visitor.visitSentence(this) != Visitor.NO_CHILDS)
		{
            // visit the MetaInformations:
            super.visit (visitor);

            // visit childs:
            if (_words != null)
			{
                Iterator iter = _words.iterator();

                while (iter.hasNext())
                    ((Word)iter.next()).visit(visitor);
            }
        }
        return Visitor.CONTINUE;
    }

    /**
     * Access to all words.
     *
     * @return Iterator over all words.
     */
    public Iterator getWords ()
    {
    	return _words.iterator();
    }

    /** Not allowd. */
    private Sentence () {super (null); }

    /** List of words. */
    public List _words = new LinkedList ();

}

