package de.jbible.tool.bibleimport;

import java.util.*;

/**
 * Data object for the string pool.
 */
public class StringPoolData implements Comparable
{
	/**
     * Create a new StringPoolData
     *
     * @param data The string of this data object.
     */
	public StringPoolData (String data)
    {
    	_data = data;
    }

    /**
     * Increment the counter of this object.
     */
    public void increment ()
    {
        _counter++;
    }

    /**
     * Access to the counter.
     *
     * @return The actual counter value.
     */
    public int getCounter ()
    {
    	return _counter;
    }

    /**
     * Access to the string.
     *
     * @return The string of this data object.
     */
	public String getString ()
    {
    	return _data;
    }

    /**
     * We want use only the string as hash-key.
     *
     * @return The hashCode of the data sting.
     */

	public int hashCode()
	{
		return _data.hashCode();
	}

    /**
     * Compare method, used for sorting.
     *
     * @param o The object to compare with.
     * @return Less then: -1, equal: 0, greater then: 1
     */
    public int compareTo(Object o)
    {
        int c = ((StringPoolData)o)._counter;
        if (c < _counter)
        	return -1;
    	if (c == _counter)
        	return 0;
        return 1;
    }

    /**
     * Debug purpose only.
     *
     * @return A string that describes this object.
     */
	public String toString ()
    {
    	return ""+_order+": "+_data+" ("+_counter+")\n";
    }


    /** The string of this object. */
    private String _data;

    /** The counter for this string. */
    private int _counter;

    /**
     * The order number of this element, if sortet.
     * It is set on the first call of
     * {@link StringPool#sort StringPool.sort}.
     */
	int _order=-1;
}
