package de.jbible.tool.bibleimport;

import java.util.*;

/**
 * Object represents a Vers.
 *
 * A vers is a sentences with optional meta informations.
 */

public class Vers extends MetaInfoContainer
{
	/**
     * Create a new object with given informations.
     *
     * @param number The vers number
     * @param sentence The sentence of this vers
     * @param meta1 First meta info
     * @param nextVers The next vers.
     */
	public Vers(String number,Sentence sentence,MetaInfo meta,
	    Vers nextVers)
	{
    	super (meta);

		_number = Integer.parseInt(number);
        Debug._versNr = _number;
    	_sentence = sentence;
        _next = nextVers;
	}

    /** Not allowed. */
    private Vers ( ) { super (null);}

    /**
     * Access to the sentence.
     *
     * @return The sentence of this vers.
     */
    public Sentence getSentence ()
    {
        return _sentence;
    }

    /**
     * Visit the whole data tree.
     *
     * @param visitor The visitor object.
     */
	public int visit (Visitor visitor)
    {
		// visit this object
    	if(visitor.visitVers(this) != Visitor.NO_CHILDS)
		{
            // visit the MetaInformations:
            super.visit (visitor);

            // visit childs:
            if (_sentence != null)
                _sentence.visit(visitor);

            // call visit bible word:
            Iterator words = _sentence.getWords();
            while (words.hasNext())
            	visitor.visitBibleWord((Word)words.next());
        }
        return Visitor.CONTINUE;
    }

	/**
     * Debuging purpose.
     *
     * @return A string that describes this object.
     */
    public String toString ()
    {
    	return "Vers "+_number;
    }

    /** The sentence. */
    public Sentence _sentence;

    /** The vers number. */
    public int _number;

    /** The next vers.
     * This references are only temporary used.
     */
	transient Vers _next;
}
