package de.jbible.tool.bibleimport;

/**
 * Visitor interface for the imported bible tree.
 *
 * There are several methods, which are called, if the
 * corresponding object is visited.
 */
public interface Visitor
{
	/**
     * Visit a book.
     *
     * @param book The visited book.
     */
	public int visitBook (Book book);

	/**
     * Visit a chapter.
     *
     * @param chapter The visited chapter.
     */
	public int visitChapter (Chapter chapter);

	/**
     * Visit a vers.
     *
     * @param vers The visited vers.
     */
	public int visitVers (Vers vers);

	/**
     * Visit a sentence.
     *
     * @param sentence The visited sentence.
     */
	public int visitSentence (Sentence sentence);

	/**
     * Visit a word.
     *
     * This method is called for each word,
     * for headlines, meta info and bible words.
     *
     * @param word The visited word.
     */
	public int visitWord (Word word);

	/**
     * Visit a bible word.
     *
     * This method is only called for bible words.
     *
     * @param word The visited word.
     */
	public int visitBibleWord (Word word);

    /**
     * Visit a metainfo.
     *
     * @param metainfo The visited metainfo.
     */
	public int visitMetaInfo (MetaInfo metainfo);

    /** Continue flag: go on proceeding. */
    public static final int CONTINUE = 1;

    /** Continue flag: Dont proceed child nodes. */
    public static final int NO_CHILDS = 2;

}
