package de.jbible.tool.bibleimport;

/**
 * This class represents a Word.
 *
 * A word is a String with optional meta informations.
 */
public class Word extends MetaInfoContainer
{
	/**
     * Create a new object with given parameters.
     *
     * @param word The word of this object.
     * @param meta Optional meta information to this word.
     */
	public Word(String word,MetaInfo meta)
	{
    	super (meta);
    	_word = word;
	}

	/**
     * Create a new object with given parameters.
     *
     * @param word The word of this object.
     */
	public Word(String word)
	{
    	this (word,null);
	}

    /**
     * Access to the word.
     *
     * @return The word.
     */
	public String getWord ()
    {
    	return _word;
    }

    /**
     * Set new word.
     *
     * @param newWord The new word to set.
     */
	public void setWord (String newWord)
    {
    	_word = newWord;
    }

    /**
     * Visit the whole data tree.
     *
     * @param visitor The visitor object.
     */
	public int visit (Visitor visitor)
    {
		// visit this object
    	if( visitor.visitWord(this)!= Visitor.NO_CHILDS)
        {
	       // visit the MetaInformations:
    	    super.visit (visitor);
        }
        return Visitor.CONTINUE;
    }

    /**
     * Debuging purpose.
     *
     * @return A string that describes this object.
     */
    public String toString ()
    {
    	return "Word: "+getWord();
    }

    /** The word.*/
    private String _word;
}
