package de.jbible.tool.misc;

import java.io.*;
import de.jbible.core.*;
/**
 * This file filter just accept one single file
 * with a specific name and size.
 *
 */
public class SingleFileFilter implements FileFilter
{

    /**
     * Create a file filter that accept only the specified file name.
     *
     * @param name The name of the file that will be accepted.
     */
    public SingleFileFilter(String name)
    {
        _name = name;
    }

    /**
     * Create a file filter that accept only the specified file name
     * with the specified file size.
     *
     * @param name The name of the file that will be accepted.
     * @param size The file size.
     */
    public SingleFileFilter (String name,long size)
    {
        this (name);
        _size = size;
    }

    /**
     * Test a file.
     *
     * @param file The file to test.
     */
    public boolean accept(File file)
    {
//        LoggingManager.log ("File: "+file+" Size: "+file.length(),this);
//        long len =file.length();
//        String f = file.getName();
        return _name.compareToIgnoreCase(file.getName()) == 0  && (_size == -1 || file.length() == _size);
    }

    /** For debug. */
    public String toString ()
    {
        return super.toString()+" Accepting: "+_name+","+_size;
    }

    /** Not allowed. */
    private SingleFileFilter () {}


    /** The name of the file that will be accepted.*/
    private String _name;

    /** The size of the file that will be accepted.
     *   -1 means that the size will not be tested.
     */
    private long _size =-1;

}
