package de.jbible.tool.swinglang;

import javax.swing.*;
import de.jbible.core.*;
/**
 * JMenuItem plus on-the-fly language exchange functionality.
 */

public class LangJComboBox extends JComboBox
{
    /**
     * Constructor that stores the service context.
     *
     * @param context The context is used to get the translation.
     */
    public LangJComboBox(ServiceContext context)
    {
        super ();
        setModel (new LangComboBoxModel (context));
    }

    /**
     * Its not allowed to use the default constructor.
     */
    private LangJComboBox ()
    {
    }

    /**
     * Method is called if the GUI change.
     *
     * This could be a change of the PLAF or the language.
     * Its called from
     * (@link javax.swing.SwingUtiltity.updateComponentTreeUI
     *   SwingUtiltity.updateComponentTreeUI)
     */
    public void updateUI ()
    {
        // send message to our model:
        ComboBoxModel model = this.getModel();

        if (model instanceof LangComboBoxModel)
            ((LangComboBoxModel)this.getModel()).updateUI();
            
        super.updateUI();
    }
}
