package de.jbible.tool.swinglang;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import de.jbible.core.*;
/**
 * JMenuItem plus on-the-fly language exchange functionality.
 */

public class LangJDialog extends JDialog
    implements WindowUpdateInterface
{
    /**
     * Constructor that stores the service context.
     *
     * @param owner The owner of this dialog, the parent window
     * @param title The title of the dialog.
     * @param context The context is used to get the translation.
     */
    public LangJDialog(Frame owner, String title,ServiceContext context)
    {
        super (owner);
        _context = context;
        setTitle (title);
    }

    /**
     * Its not allowed to use the default constructor.
     */
    private LangJDialog ()
    {
    }

    /**
     * Set the text as a key to the ResourceBundle.
     *
     * The method translate the text and store it in the control.
     *
     * @param title The key to the ResourceBundle
     */
    public void setTitle(String title)
    {
        _title = title;
        if (_context != null)
        {
            // get translation for the text:
            Object translation = _context.translate (title);

            if (translation != null && translation instanceof String)
                super.setTitle( (String)translation);
        }
        else
        {
            super.setTitle (title);
        }
    }

    /**
     * Method is called if the GUI change.
     *
     * This could be a change of the PLAF or the language.
     * Its called from
     * (@link javax.swing.SwingUtiltity.updateComponentTreeUI
     *   SwingUtiltity.updateComponentTreeUI)
     */
    public void updateUI ()
    {
        // get new translation for the text:
        setTitle (_title);
        pack();
        validate ();

        // call action listeners
        Iterator iter = _uiListeners.iterator();
        UpdateUIListener listener;

        while (iter.hasNext())
            ((UpdateUIListener)iter.next()).uiChanged();

    }


    /**
     * Add a UpdateUIListener to this object.
     *
     * @param listener The new listener.
     */
    public void addUIListener (UpdateUIListener listener)
    {
        _uiListeners.add(listener);
    }

    /**
     * Remove a UpdateUIListener from this object.
     *
     * @param listener The listener to remove.
     */
    public boolean removeUIListener (UpdateUIListener listener)
    {
        return _uiListeners.remove (listener);
    }

    /** List of all ui listeners. */
    private transient java.util.List _uiListeners = new LinkedList ();

    /** The service context which translate for us. */
    private transient ServiceContext _context = null;
    /** The title key for translation. */
    private String _title = "";

    /**
     * To check, if dialogs will be finallized.
     */
    protected void finalize() throws java.lang.Throwable
    {
        LoggingManager.log ("Finalize dialog"+getTitle(),"");
        super.finalize();
    }


}
