package de.jbible.tool.swinglang;

import javax.swing.*;
import de.jbible.core.*;
/**
 * JMenuItem plus on-the-fly language exchange functionality.
 */

public class LangJLabel extends JLabel
{
    /**
     * Constructor that stores the service context.
     *
     * @param context The context is used to get the translation.
     */
    public LangJLabel(ServiceContext context)
    {
        _context = context;
    }
    /**
     * Constructor that stores the service context and the text of the label
     *
     * @param text The text of the label
     * @param context The context is used to get the translation.
     */
    public LangJLabel(String text,ServiceContext context)
    {
        _context = context;
        setText (text);
    }
    /**
     * Its not allowed to use the default constructor.
     */
    private LangJLabel ()
    {
    }

    /**
     * Set the text as a key to the ResourceBundle.
     *
     * The method translate the text and store it in the control.
     *
     * @param text The key to the ResourceBundle
     */
    public void setText(String text)
    {
        _text = text;
        if (_context != null)
        {
            // get translation for the text:
            Object translation = _context.translate (text);

            if (translation != null && translation instanceof String)
                super.setText( (String)translation);
        }
        else
        {
            super.setText (text);
        }
    }

    /**
     * Method is called if the GUI change.
     *
     * This could be a change of the PLAF or the language.
     * Its called from
     * (@link javax.swing.SwingUtiltity.updateComponentTreeUI
        SwingUtiltity.updateComponentTreeUI)
     */
    public void updateUI ()
    {
        // get new translation for the text:
        setText (_text);
        super.updateUI();
    }

    /** The service context which translate for us. */
    private transient ServiceContext _context = null;
    /** The text key for translation. */
    private String _text = "";
}
