package de.jbible.tool.swinglang;

import javax.swing.*;
import de.jbible.core.*;
/**
 * JMenuItem plus on-the-fly language exchange functionality.
 */

public class LangJMenuItem extends JMenuItem
{
    /**
     * Constructor that stores the service context.
     *
     * @param context The context is used to get the translation.
     */
    public LangJMenuItem(ServiceContext context)
    {
        _context = context;
    }

    /**
     * Its not allowed to use the default constructor.
     */
    private LangJMenuItem ()
    {
    }

    /**
     * Set the text as a key to the ResourceBundle.
     *
     * The method translate the text and store it in the control.
     *
     * @param text The key to the ResourceBundle
     */
    public void setText(String text)
    {
        _text = text;
        if (_context != null)
        {
            // get translation for the text:
            Object translation = _context.translate (text);

            if (translation != null && translation instanceof String)
                super.setText( (String)translation);
        }
        else
        {
            super.setText (text);
        }
    }

    /**
     * Set the tool tip text as a key to the ResourceBundle.
     *
     * The method translate the text and store it in the control.
     *
     * @param text The key to the ResourceBundle
     */
    public void setToolTipText(String text)
    {
        _toolTipText = text;
        if (_context != null)
        {
            // get translation for the text:
            Object translation = _context.translate (text);

            if (translation != null && translation instanceof String)
                super.setToolTipText ((String)translation);

        }
        else
        {
            super.setToolTipText (text);
        }
    }
    /**
     * Method is called if the GUI change.
     *
     * This could be a change of the PLAF or the language.
     * Its called from
     * (@link javax.swing.SwingUtiltity.updateComponentTreeUI
     *   SwingUtiltity.updateComponentTreeUI)
     */
    public void updateUI ()
    {
        // get new translation for the text:
        setText (_text);
        setToolTipText (_toolTipText);

        super.updateUI();
    }

    /** The service context which translate for us. */
    private transient ServiceContext _context = null;
    /** The text key for translation. */
    private String _text = "";
    /** The tool tip text key for translation. */
    private String _toolTipText = "";

}