package de.jbible.tool.swinglang;

/**
 * This interface is implemented by window SWING objects to handle
 * a PLAF or language update.
 *
 * This interface defines also the handling of UpdateUIListener.
 */
public interface WindowUpdateInterface
{
    /**
     * The Language and or the PLAF has changed.
     */
    public abstract void updateUI ();

    /**
     * Add a UpdateUIListener to this object.
     *
     * @param listener The new listener.
     */
    public abstract void addUIListener (UpdateUIListener listener);

    /**
     * Remove a UpdateUIListener from this object.
     *
     * @param listener The listener to remove.
     * @return true, if the action was successful, else false.
     */
    public abstract boolean removeUIListener (UpdateUIListener listener);


}
