package de.jbible.tool.swingmisc;
import de.jbible.core.*;

import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
/**
 * This Action Listener closes the actual internal frame and frees the resources.
 */
public class CloseJInternalFrameActionListener implements ActionListener
{

    /**
     * Is called, if the action occures.
     *
     * @param e The event description.
     */
    public void actionPerformed(ActionEvent e)
    {
        // find the JDesctopPane
        Component c = (Component)e.getSource ();

        while (c != null && !(c instanceof JInternalFrame))
        {
            c = c.getParent();
        }
        if (c != null)
        {
//            c.setVisible(false);
//            c.getParent().remove(c);
            ((JInternalFrame)c).dispose();
        }
        else
        {
            LoggingManager.error("Can't Close dialog from event:"+e,
                this);
        }



        // find the JDesctopPane
/*        Component c = (Component)e.getSource ();
        JInternalFrame frame = null;

        while (c != null && !(c instanceof JDesktopPane))
        {
            if (c instanceof JInternalFrame)
                frame = (JInternalFrame)c;
            c = c.getParent();
        }
        if (c != null && frame != null)
        {
            ((JDesktopPane)c).remove(frame);
            frame.dispose();
        }
        */


    }
}
