package de.jbible.tool.swingmisc;

import java.awt.event.*;
import de.jbible.core.*;

/**
 * Abstract ActionListener that stores a service reference.
 *
 * This is used for services that are registered to other services (specially
 * to WindowService)
 * They must know the context, e.G. where to start a dialog.
 */
public abstract class ServiceActionListener implements ActionListener
{
    /**
     * Parameterless constructor not allowed.
     */
    private ServiceActionListener()
    {
    }

    /**
     * Store a service reference in ActionListener.
     *
     * @param service The service reference
     */
    public ServiceActionListener(Service service)
    {
        _service = service;
    }

    /** The reference to the service in which this action runs. */
    protected Service _service;
}
