package jay.yydebug;

import java.awt.*;
import java.awt.event.*;

/** An implementation of yyDebug with a graphical interface.
    This has not been checked to be serializable.
  */

public class yyAnim extends Frame implements yyDebug {

  protected transient static int nFrames;	// controls exit
  { ++ nFrames;					// new instance
  }

  /** trap System.in */		public static final int IN = 1;
  /** trap System.out, .err */  public static final int OUT = 2;

  protected transient yyAnimPanel panel;	// input, stack, comment
  protected transient Thread eventThread;	// set by Checkbox-listener
  protected transient boolean outputBreak	// breakpoint, only! set in GUI
				 = false;

				/** creates and displays the frame
				    @param io trap System.in and/or .out,.err
				 */
  public yyAnim (String title, int io) {
    setTitle(title);

    Font font = new Font("Monospaced", Font.PLAIN, 12);

    MenuBar mb = new MenuBar();
      Menu m = new Menu("yyAnim");
        MenuItem mi = new MenuItem("Quit");
          mi.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent ae) {
	      System.exit(0);
            }
          });
        m.add(mi);
      mb.add(m);
    setMenuBar(mb);

    add(panel = new yyAnimPanel(font), "Center");

    if ((io & (IN|OUT)) != 0) {
      Panel p = new Panel(new BorderLayout());
	switch (io) {
	case IN:
          p.add(new Label("terminal input"), "North");
	  break;
	case OUT: case IN|OUT:
	  Checkbox c;
	  String ct = (io&IN) != 0 ? "terminal i/o" : "terminal output";
          p.add(c = new Checkbox(ct, outputBreak), "North");
            c.addItemListener(new ItemListener() {
	      public void itemStateChanged (ItemEvent ie) {
	        eventThread = Thread.currentThread();
	        outputBreak = ie.getStateChange() == ie.SELECTED;
              }
            });
	}

	final TextArea t;
        p.add(t = new TextArea(10, 50), "Center");
          t.setBackground(Color.white); t.setFont(font);

	  if ((io&IN) != 0) {
            yyInputStream in = new yyInputStream();
            t.addKeyListener(in); t.setEditable(true);
            System.setIn(in);
	  }

	  if ((io&OUT) != 0) {
            System.setOut(new yyPrintStream() {	// PrintStream into TextArea
	      public void close () { }
	      public void write (byte b[], int off, int len) {
	        String s = new String(b, off, len);
	        t.append(s); t.setCaretPosition(t.getText().length());
	        if (outputBreak && s.indexOf("\n") >= 0 && eventThread != null
	            && Thread.currentThread() != eventThread)
	          try {
	            synchronized (panel) { panel.wait(); }
	          } catch (InterruptedException ie) { }
	      }
	      public void write (int b) {
	        write(new byte[] { (byte)b }, 0, 1);
	      }
            });
            System.setErr(System.out);
	  }
      add(p, "South");
    }

    addWindowListener(new WindowAdapter() {
      public void windowClosing (WindowEvent we) {
	dispose();
        if (-- nFrames <= 0) System.exit(0);
      }
    });
    pack();
    setStaggeredLocation(this);
    show();
  }

  public static void setStaggeredLocation (Component c) {
    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension d = c.getPreferredSize();

    int x = (screen.width - d.width)/2 + (nFrames-1)*32;
    if (x < 32) x = 32;
    else if (x > screen.width-128) x = screen.width-128;

    int y = (screen.height - d.height)/2 + (nFrames-1)*32;
    if (y < 32) y = 32;
    else if (y > screen.height-128) y = screen.height-128;

    c.setLocation(x, y);
  }

  public synchronized void lex (int state, int token, String name, Object value)
  { panel.lex(state, token, name, value);
  }

  public void shift (int from, int to, int errorFlag) {
    panel.shift(from, to, errorFlag);
  }

  public void discard (int state, int token, String name, Object value) {
    panel.discard(state, token, name, value);
  }

  public void shift (int from, int to) {
    panel.shift(from, to);
  }

  public synchronized void accept (Object value) {
    panel.accept(value);
  }

  public void error (String message) {
    panel.error(message);
  }

  public void reject () {
    panel.reject();
  }

  public synchronized void push (int state, Object value) {
    panel.push(state, value);
  }

  public synchronized void pop (int state) {
    panel.pop(state);
  }

  public synchronized void reduce (int from, int to, int rule, String text,
								int len) {
    panel.reduce(from, to, rule, text, len);
  }
}
