package jay.yydebug;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

/** feeds an InputStream from a TextArea (only!)<br>
    as one should not read from within the event thread,
    this should not deadlock
 */

public class yyInputStream extends InputStream implements KeyListener {
  protected final StringBuffer line = new StringBuffer();
  protected Vector queue = new Vector();	// null after close()

  public synchronized int available () throws IOException {
    if (queue == null) throw new IOException("closed");
    return queue.isEmpty() ? 0 : ((byte[])queue.firstElement()).length;
  }

  public synchronized void close () throws IOException {
    if (queue == null) throw new IOException("closed");
    queue = null;
  }

  public synchronized int read () throws IOException {
    if (queue == null) throw new IOException("closed");
    while (queue.isEmpty())
      try {
        wait();
      } catch (InterruptedException ie) { }

    byte[] buf = (byte[])queue.firstElement();
    switch (buf.length) {
    case 0:
      return -1;
    case 1:
      queue.removeElementAt(0);
      break;
    default:
      byte[] nbuf = new byte[buf.length-1];
      System.arraycopy(buf, 1, nbuf, 0, nbuf.length);
      queue.setElementAt(nbuf, 0);
    }
    return buf[0] & 255;
  }

  public synchronized int read(byte[] b, int off, int len) throws IOException {
    if (queue == null) throw new IOException("closed");
    while (queue.isEmpty())
      try {
        wait();
      } catch (InterruptedException ie) { }

    byte[] buf = (byte[])queue.firstElement();
    if (buf.length == 0) return -1;

    if (buf.length <= len) {
      System.arraycopy(buf, 0, b, off, buf.length);
      queue.removeElementAt(0);
      return buf.length;
    }
    
    System.arraycopy(buf, 0, b, off, len);
    byte[] nbuf = new byte[buf.length-len];
    System.arraycopy(buf, len, nbuf, 0, nbuf.length);
    queue.setElementAt(nbuf, 0);
    return len;
  }

  public long skip (long len) {
    return 0;				// don't skip on terminal
  }

  // BUG: Rhapsody DR2 seems to not send some keys to keyTyped()
  //	e.g. German keyboard + is dropped, but numeric pad + is processed

  public void keyTyped (KeyEvent ke) {
    TextArea ta = (TextArea)ke.getComponent();
    char ch = ke.getKeyChar();

    switch (ch) {
      case '\n': case '\r':		// \n|\r -> \n, release line
	line.append('\n');
	break;

      case 'D'&31:			// ^D: release line
	ta.append("^D"); ta.setCaretPosition(ta.getText().length());
	break;

      case '\b':			// \b: erase char, if any
	int len = line.length();
	if (len > 0) line.setLength(len-1);
	return;

      case 'U'&31:			// ^U: erase line, if any
	line.setLength(0);
	ta.append("^U\n"); ta.setCaretPosition(ta.getText().length());
	return;

      default:
	line.append(ch);
	return;
    }
    synchronized(this) {
      queue.addElement(line.toString().getBytes());
      notify();
    }
    line.setLength(0);
  }

  public void keyPressed (KeyEvent ke) {
  }

  public void keyReleased (KeyEvent ke) {
  }
}
