package junit.tests;

import java.util.Vector;
import junit.framework.*;

/**
 * A test case testing the testing framework.
 *
 */
public class TestTest extends TestCase {
	
	static class TornDown extends TestCase {
		boolean tornDown= false;
		
		TornDown(String name) {
			super(name);
		}
		protected void tearDown() {
			tornDown= true;
		}
		protected void runTest() {
			throw new Error();
		}
	}
	public TestTest(String name) {
		super(name);
	}
	public static Test suite() {
		return new TestSuite(TestTest.class);
	}
	public void testAssertEquals() {
		Object o= new Object();
		assertEquals(o, o);
	}
	public void testAssertEqualsNull() {
		assertEquals(null, null);
	}
	public void testAssertNull() {
		TestCase succeeds= new TestCase("isnull") {
			protected void runTest() {
				assertNull(null);
			}
		};
		verifySuccess(succeeds);
	}
	public void testAssertNullNotEqualsNull() {
		TestCase fails= new TestCase("fails") {
			protected void runTest() {
				assertEquals(null, new Object());
			}
		};
		verifyFailure(fails);
	}
	public void testAssertSame() {
		Object o= new Object();
		assertSame(o, o);
	}
	public void testAssertSameFails() {
		TestCase assertSame= new TestCase("assertSame") {
			protected void runTest() {
				assertSame(new Integer(1), new Integer(1));
			}
		};
		verifyFailure(assertSame);
	}
	public void testError() {
		TestCase error= new TestCase("error") {
			protected void runTest() {
				throw new Error();
			}
		};
		verifyError(error);
	}
	public void testFail() {
		TestCase failure= new TestCase("fail") {
			protected void runTest() {
				fail();
			}
		};
		verifyFailure(failure);
	}
	public void testFailAssertNotNull() {
		TestCase failure= new TestCase("fails") {
			protected void runTest() {
				assertNotNull(null);
			}
		};
		verifyFailure(failure);
	}
	public void testFailure() {
		TestCase failure= new TestCase("failure") {
			protected void runTest() {
				assert(false);
			}
		};
		verifyFailure(failure);
	}
	public void testRunAndTearDownFails() {
		TornDown fails= new TornDown("fails") {
			protected void tearDown() {
				super.tearDown();
				throw new Error();
			}
			protected void runTest() {
				throw new Error();
			}
		};
		verifyError(fails);
		assert(fails.tornDown);
	}
	public void testSetupFails() {
		TestCase fails= new TestCase("success") {
			protected void setUp() {
				throw new Error();
			}
			protected void runTest() {
			}
		};
		verifyError(fails);
	}
	public void testSucceedAssertNotNull() {
		assertNotNull(new Object());
	}
	public void testSuccess() {
		TestCase success= new TestCase("success") {
			protected void runTest() {
				assert(true);
			}
		};
		verifySuccess(success);
	}
	public void testTearDownAfterError() {

		TornDown fails= new TornDown("fails");
		verifyError(fails);
		assert(fails.tornDown);
	}
	public void testTearDownFails() {
		TestCase fails= new TestCase("success") {
			protected void tearDown() {
				throw new Error();
			}
			protected void runTest() {
			}
		};
		verifyError(fails);
	}
	public void testTearDownSetupFails() {
		TornDown fails= new TornDown("fails") {
			protected void setUp() {
				throw new Error();
			}
		};
		verifyError(fails);
		assert(!fails.tornDown);
	}
	public void testWasNotSuccessful() {
		TestCase failure= new TestCase("fail") {
			protected void runTest() {
				fail();
			}
		};
		TestResult result= failure.run();
		assert(result.runTests() == 1);
		assert(result.testFailures() == 1);
		assert(result.testErrors() == 0);
		assert(! result.wasSuccessful());
	}
	public void testWasSuccessful() {
		TestCase success= new TestCase("success") {
			protected void runTest() {
				assert(true);
			}
		};
		TestResult result= success.run();
		assert(result.runTests() == 1);
		assert(result.testFailures() == 0);
		assert(result.testErrors() == 0);
		assert(result.wasSuccessful());
	}
	private void verifyError(TestCase test) {
		TestResult result= test.run();
		assert(result.runTests() == 1);
		assert(result.testFailures() == 0);
		assert(result.testErrors() == 1);
	}
	private void verifyFailure(TestCase test) {
		TestResult result= test.run();
		assert(result.runTests() == 1);
		assert(result.testFailures() == 1);
		assert(result.testErrors() == 0);
	}
	private void verifySuccess(TestCase test) {
		TestResult result= test.run();
		assert(result.runTests() == 1);
		assert(result.testFailures() == 0);
		assert(result.testErrors() == 0);
	}
}