//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Verwaltung der Medien-Daten
//  Distributions- Version
//*******************************
#include <assign.h>
#include <classlib\arrays.h>
#include <stdio.h>
#include <alloc.h>

#define MAXCOPYBUF  65535

//*******************************
//  Medientabelle
//*******************************
// Datensatz fr Medientabelle
struct SRData
{
	int iIdent;
	int iPos;
	int iLenght;

	SRData (int iIdentifier) { iIdent = iIdentifier; }
};

int operator==(const SRData& a,const SRData& b)
{
	return a.iIdent == b.iIdent;
}

int operator<(const SRData& a,const SRData& b)
{
	return a.iIdent < b.iIdent;
}

// Array der Medientabellen
typedef TISArrayAsVector <SRData> TDataArray;

//*******************************
//  Extrahierte Mediendateien
//	   Tabelle
//*******************************
struct SRTempFile
{
	int iIdent;
	char szFile[MAX_PATH];

	SRTempFile (int iIdentifier)
		{ iIdent = iIdentifier; }
};

int operator==(const SRTempFile& a,const SRTempFile& b)
{
	return a.iIdent == b.iIdent;
}

int operator<(const SRTempFile& a,const SRTempFile& b)
{
	return a.iIdent < b.iIdent;
}
typedef TISArrayAsVector <SRTempFile> TTempFileArray;


//*******************************
//  Media-File Datensatz
//*******************************
// Datensatz fr einen Medienzugriff
struct SRMediaFile
{
	HANDLE hFile;
	TDataArray oTab;
	TTempFileArray oTemp;
	int iAccessCount;
	char szForm [MAX_PATH];

	SRMediaFile (const char *cszFormName)
		: oTab (10,0,10),
		  oTemp (10,0,10)
		{ hFile = 0; iAccessCount = 1; strcpy (szForm,cszFormName); }

	~SRMediaFile (); // Temps entfernen

};

SRMediaFile::~SRMediaFile ()
{
	int i,count = oTemp.GetItemsInContainer ();

	// Temporrer Dateien lschen
	for (i=0;i< count;i++) {
		remove (oTemp[i] -> szFile);
	}
}

int operator==(const SRMediaFile& a,const SRMediaFile& b)
{
	return strcmp (a.szForm,b.szForm) == 0;
}

int operator<(const SRMediaFile& a,const SRMediaFile& b)
{
	return strcmp (a.szForm,b.szForm) < 0;
}

//*******************************
// Tabelle der Medienzugriffe
//*******************************
typedef TISArrayAsVector <SRMediaFile> TMediaAccessArray;

static TMediaAccessArray oMediaAccess (10,0,10);

// Medienzugriff ffen
// liefert einen Handle auf die Medien des Formulars
void* FAR PASCAL _export MMOpenMedia (
		const char *cszFormName) // Name des Formulas
{
	char szBuf [MAX_PATH];
	int iCount,i;
	DWORD temp;
	SRData *pData,*pOldData;
	SRMediaFile *pMediaFile;

	// ist Medium bereits geffnet?
	i = oMediaAccess.Find (&SRMediaFile (cszFormName));
	if (i != INT_MAX) {
		// gefundenen Datensatz ermitteln:
		pMediaFile = oMediaAccess [i];

		// ZUgriffszhler erhhen
		pMediaFile -> iAccessCount ++;

		// und Zeiger zurckgeben
		return pMediaFile;
	}


	// Datenstruct erzeugen
	pMediaFile = new SRMediaFile (cszFormName);
	if (pMediaFile) {

   	oMediaAccess.Add (pMediaFile);

		// Dateiname erzeugen
		strcpy (szBuf,cszFormName);
		szBuf[8] = '\0';
		strcat (szBuf,".MDA");

		pMediaFile -> hFile = CreateFile (szBuf,GENERIC_READ,FILE_SHARE_READ,
													NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL |
													FILE_FLAG_RANDOM_ACCESS,NULL);

		if (pMediaFile -> hFile == INVALID_HANDLE_VALUE) {
			// Im Fehlerfall struct lschen und ende
			delete pMediaFile;
			pMediaFile = 0;
		} else {

			// Anzahl der Medien ermitteln
			ReadFile (pMediaFile -> hFile,&iCount,sizeof (iCount),&temp,NULL);
			pOldData = NULL;

			// Medientabelle einlesen:
			for (i=0;i <= iCount;i++) { // letzter Eintrag ist nicht in count enthalten, daher <=
				pData = new SRData (0);
				if (pData) {
					// Datensatz lesen
					ReadFile (pMediaFile -> hFile,pData,8,&temp,NULL); // Nur Ident und Pos lesen, len wird berechnet
					if (pOldData)	// Lnge des vorherigen Mediums berechnen:
						pOldData -> iLenght = pData -> iPos - pOldData -> iPos;

					pOldData = pData;

					if (pData -> iIdent != -1) {
						// und in Tabelle schreiben
						pMediaFile -> oTab.Add (pData);
					} else { // letzten Identifier -1 nicht speichern:
						delete pData;
						pOldData = pData = NULL;
					}
				}
			}
		}

	}
	return pMediaFile;


}

// Zugriff auf Mediendatem
// Die Daten werden in den Buffer kopiert.
// Sind keine Daten vorhanden, wird der Buffer mit 0 initialisiert.
void FAR PASCAL _export MMGetMedia (
		void *pHandle, 	// Medien-Handle des Formulase, liefert MMOpenMedia
		int iIdentifier, // Identifier der Medien-Daten
		void *pBuffer,   // Pointer auf Buffer, in dem die Mediendaten kopiert werden
		int iBufSize)		// Maximale Buffergre
{
	SRMediaFile *pMediaFile = (SRMediaFile*) pHandle;
	if (pMediaFile) {
		SRData *pData;
		int iIndex;
		DWORD temp;

		// Index des Datensatzes ermitteln
		iIndex = pMediaFile -> oTab.Find (&SRData (iIdentifier));

		if (iIndex == INT_MAX) {
			// Identifier nicht vorhanden:
			memset (pBuffer,0,iBufSize); // Speicher leeren
		} else {
			pData = pMediaFile -> oTab[iIndex];

			// Dateizeiger positionieren
			SetFilePointer (pMediaFile -> hFile,pData -> iPos,NULL,FILE_BEGIN);

			// und Daten auslesen
			ReadFile (pMediaFile -> hFile,pBuffer,iBufSize,&temp,NULL);
		}
	}
}

// Zugriff auf eine Mediendatei. Im Distribution-Modus wird die Datei
// aus der .MDA- Datei auf Festplatte kopiert und beim Schlieen
// wieder terminiert.
void FAR PASCAL _export MMGetMediaFile (
		void *pHandle, 	// Medien-Handle des Formulase, liefert MMOpenMedia
		int iIdentifier, // Identifier der Medien-Daten
		char *szFilename) // Buffer fr Dateiname, mu MAX_PATH gro sein!
{
	SRMediaFile *pMediaFile = (SRMediaFile*) pHandle;

	// Default :
	szFilename [0] = '\0';

	if (pMediaFile && iIdentifier > 0) { // Ist Handle gltig?
		SRData *pData;
		int iIndex,iTempIndex;

		// Index des Datensatzes ermitteln
		iIndex = pMediaFile -> oTab.Find (&SRData (iIdentifier));
		if (iIndex != INT_MAX) {
			SRTempFile *pTempFile;

			// Wurde Mediendatei bereits temporr auf Festplatte kopiert?
			iTempIndex = pMediaFile -> oTemp.Find (&SRTempFile (iIdentifier));

			if (iTempIndex != INT_MAX) {
				// Gefunden !!
				pTempFile = pMediaFile -> oTemp[iTempIndex]; // Datensatz ermitteln
				// Dateiname in Rckgabe-Buffer kopieren
				strcpy (szFilename,pTempFile -> szFile);
				// Fertig!
			} else {
				//  Datei in Temporres Verzeichnis kopieren
				char szTempPath [MAX_PATH];
				void *pCopyBuffer;
				int iCopyBufSize;
				DWORD iTemp,iRead;
				HANDLE hOut;
				int iLength;

				// Zeiger auf Medien-Datensatz ermitteln
				pData = pMediaFile -> oTab[iIndex];

				// MedienGre ermitteln
				iLength = pData -> iLenght;

				// Dateizeiger positionieren
				SetFilePointer (pMediaFile -> hFile,pData -> iPos,NULL,FILE_BEGIN);

				// KopierBuffer erzeugen
				iCopyBufSize = (iLength > MAXCOPYBUF)? MAXCOPYBUF:iLength;
				pCopyBuffer = farmalloc (iCopyBufSize);
				if (pCopyBuffer) {

					// Objekt zur Speicherung der temporren Daten erzeugen
					pTempFile = new SRTempFile (iIdentifier);

					// Temporren Dateinamen erzeugen:
					GetTempPath (MAX_PATH,szTempPath);
					GetTempFileName (szTempPath,".Temporary",iIdentifier,pTempFile -> szFile);

					// Ausgabedatei ffnen
					hOut = CreateFile (pTempFile -> szFile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,
											  FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_SEQUENTIAL_SCAN,NULL);
					// Hats geklappt?
					if (hOut !=  INVALID_HANDLE_VALUE) {
						// Daten kopieren
						while (iLength > 0) {
							iRead = (iLength > iCopyBufSize)?iCopyBufSize:iLength;
							ReadFile (pMediaFile -> hFile,pCopyBuffer,iRead,&iTemp,NULL);
							WriteFile (hOut,pCopyBuffer,iRead,&iTemp,NULL);
							iLength -= iRead;
						}
						// und der Tabelle der Temorren Dateien hinzufgen
						pMediaFile -> oTemp.Add (pTempFile);

						// Dateiname in Rckgabe-Buffer kopieren
						strcpy (szFilename,pTempFile -> szFile);
						// Fertig!

						// Schreibdatei schlieen
						CloseHandle (hOut);
					}
					// Kopierpuffer freigeben:
					farfree (pCopyBuffer);
				}
			}
		}
	}
}

// Medienzugriff schlieen
// Anschlieend ist pHandle ungltig!
void FAR PASCAL _export MMCloseMedia (void* pHandle)
{
	SRMediaFile *pMediaFile = (SRMediaFile*) pHandle;

	// Datenstruct freigeben
	if (pMediaFile) {
		// Zugriffszhler vermindern
		pMediaFile -> iAccessCount --;

		if (pMediaFile -> iAccessCount <= 0) {
			// Ist der Zugriffszhler <= 0, dann
			// Zugriffsdaten entfernen
			if (pMediaFile -> hFile) {
				// Datei schlieen
				CloseHandle (pMediaFile -> hFile);
				pMediaFile -> hFile = 0;
			}
			oMediaAccess.Destroy (pMediaFile);
		}
	}
}
