//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Verwaltung der Medien-Daten
//  Entwurfs- Version
//*******************************
#include <assign.h>
#include <propmain.h>
#include <stdlib.h>
#include <buffers.h>

//*******************************
//		SRAccessData
//*******************************
// Zugriffssdaten fr Zugriff
// auf Mediendaten
//*******************************
struct SRAccessData
{
	char* szFormName;


	SRAccessData (const char *cszFormName);
	~SRAccessData ();
};

SRAccessData::SRAccessData (const char *cszFormName)
{
	szFormName = strdup (cszFormName); // Name merken
}

SRAccessData::~SRAccessData ()
{
	if (szFormName) // String freigeben
		free (szFormName);
}


// Medienzugriff ffen
// liefert einen Handle auf die Medien des Formulars
void* FAR PASCAL _export MMOpenMedia (
		const char *cszFormName) // Name des Formulas
{
	// Acccess-Datensatz erzeugen und zurckliefern
	return new SRAccessData (cszFormName);
}



// Zugriff auf Mediendatem
// Die Daten werden in den Buffer kopiert.
// Sind keine Daten vorhanden, wird der Buffer mit 0 initialisiert.
void FAR PASCAL _export MMGetMedia (
		void *pHandle, 	// Medien-Handle des Formulase, liefert MMOpenMedia
		int iIdentifier, // Identifier der Medien-Daten
		void *pBuffer,   // Pointer auf Buffer, in dem die Mediendaten kopiert werden
		int iBufSize)		// Maximale Buffergre
{
	TBuffer bfFile (MAX_PATH);
	HANDLE hFile;

	// Name der Mediendatei ermitteln:
	strcpy (bfFile,PBGetMediaPath (((SRAccessData*)pHandle) -> szFormName));
	strcat (bfFile,"Media.");
	itoa (iIdentifier,(char*)bfFile + strlen (bfFile),10);

	// Datei ffnen
	hFile = CreateFile (bfFile,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN,0);

	if (hFile != INVALID_HANDLE_VALUE) {
		DWORD read;
      // Datei lesen	
		ReadFile (hFile,pBuffer,iBufSize,&read,0);

		// Datei wieder schlieen
		CloseHandle (hFile);
	} else {
		// Wenn Datei nicht ffenbar, Buffer mit 0 initialisieren
		ZeroMemory (pBuffer,iBufSize);
	}
}

// Zugriff auf eine Mediendatei. Im Distribution-Modus wird die Datei
// aus der .MDA- Datei auf Festplatte kopiert und beim Schlieen
// wieder terminiert.
void FAR PASCAL _export MMGetMediaFile (
		void *pHandle, 	// Medien-Handle des Formulase, liefert MMOpenMedia
		int iIdentifier, // Identifier der Medien-Daten
		char *szFilename) // Buffer fr Dateiname, mu MAX_PATH gro sein!
{
	if (pHandle && iIdentifier > 0) {
		// Name der Mediendatei ermitteln:
		strcpy (szFilename,PBGetMediaPath (((SRAccessData*)pHandle) -> szFormName));
		strcat (szFilename,"Media.");
		itoa (iIdentifier,(char*)szFilename + strlen (szFilename),10);
	} else {
		szFilename[0] = '\0';
	}
}


// Medienzugriff schlieen
// Anschlieend ist pHandle ungltig!
void FAR PASCAL _export MMCloseMedia (void* pHandle)
{
	if (pHandle)	// Daten wiedder freigeben
		delete (SRAccessData*) pHandle;
}

