//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Verwaltung der Medien-Daten
//*******************************
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

extern "C" {
	// Medienzugriff ffen
	// liefert einen Handle auf die Medien des Formulars
	void* FAR PASCAL _export MMOpenMedia (
			const char *cszFormName); // Name des Formulas


	// Zugriff auf Mediendatem
	// Die Daten werden in den Buffer kopiert.
	// Sind keine Daten vorhanden, wird der Buffer mit 0 initialisiert.
	void FAR PASCAL _export MMGetMedia (
			void *pHandle, 	// Medien-Handle des Formulase, liefert MMOpenMedia
			int iIdentifier, // Identifier der Medien-Daten
			void *pBuffer,   // Pointer auf Buffer, in dem die Mediendaten kopiert werden
			int iBufSize);		// Maximale Buffergre

	// Zugriff auf eine Mediendatei. Im Distribution-Modus wird die Datei
	// aus der .MDA- Datei auf Festplatte kopiert und beim Schlieen
	// wieder terminiert.
	void FAR PASCAL _export MMGetMediaFile (
			void *pHandle, 	// Medien-Handle des Formulase, liefert MMOpenMedia
			int iIdentifier, // Identifier der Medien-Daten
			char *szFilename); // Buffer fr Dateiname, mu MAX_PATH gro sein!


	// Medienzugriff schlieen
	// Anschlieend ist pHandle ungltig!
	void FAR PASCAL _export MMCloseMedia (void* pHandle);
}
