//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Browse for Folder
//   fr Delphi 2.0
//*******************************
#include <shellfnc.h>


int CALLBACK BrowseCallbackProc(

	 HWND  hwnd,
	 UINT  uMsg,
	 LPARAM  /*lParam*/,
	 LPARAM  lpData)
{
	switch (uMsg) {
		case BFFM_INITIALIZED  :
		{
			if (lpData)
				SendMessage (hwnd,BFFM_SETSELECTION,FALSE,(long)lpData);
			break;
		}

	}
	return 0;
}

extern "C" {

int FAR PASCAL _export BrowseFolder (HWND hParent,char *cszTitle,char *szPath,char *szBuffer,int iOptions)
{
	BROWSEINFO oInfo;
	ITEMIDLIST *pItem;
	int i;
	HRESULT hErg;
	ITEMIDLIST *pSelectedItem;

	if (szPath[0] != '\0') {
		IShellFolder *pFolder;
		wchar_t wszBuf [MAX_PATH];
		ULONG ulEaten,ulAtt;

		SHGetDesktopFolder (&pFolder);

		// Path-Name in Wide Char:
		MultiByteToWideChar (CP_ACP,0,szPath,-1,wszBuf,MAX_PATH);

		pFolder -> ParseDisplayName (hParent,NULL,wszBuf,&ulEaten,&pSelectedItem,&ulAtt);

	} else
		pSelectedItem = NULL;


	// Struktur fllen
	oInfo.hwndOwner = hParent;
	oInfo.pidlRoot = 0;
	oInfo.pszDisplayName = szBuffer;
	oInfo.lpszTitle = cszTitle;
	oInfo.ulFlags = iOptions;
	oInfo.lpfn = BrowseCallbackProc;
	oInfo.lParam = (long) pSelectedItem;
	oInfo.iImage = 0;

	pItem = SHBrowseForFolder (&oInfo);

	if (pItem != NULL) {
		LPSHELLFOLDER pFolder;
		STRRET oRet;

		// Desktop-Folder ermitteln
		hErg = SHGetDesktopFolder (&pFolder);

		oRet.cStr[0] = '\0';
		// Vollstndigen Namen ermitteln
		pFolder -> GetDisplayNameOf (pItem,SHGDN_FORPARSING,&oRet);


		// Ergebnis kopieren, per Hand da Laufzeitbibliothek nicht erlaubt!
		for (i=0;oRet.cStr[i] != 0; i++)
			szPath[i] = oRet.cStr[i];

		szPath[i] = '\0'; // und Terminieren

	}

	return (hErg == NOERROR);
}

}
