//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Verwaltung der Delphi
//   Property- Daten
//*******************************

#include <propbase.h>
extern TPropertyBase *pBase;
extern TFileSys *pFileSys;



//*******************************
//	 TPropertyBase
//*******************************
//  Verwaltung der Delphi
//	 Property- Daten
//*******************************

// Aufbau eines Keys:
// Formular:Component:Property

TPropertyBase::TPropertyBase (void) : m_stAktuell ("")
{
	TBuffer bfPath (MAX_PATH),bfKey(MAX_PATH),bfValue (MAX_PATH);
	DWORD dwValueSize = MAX_PATH,dwDataSize = MAX_PATH,dwTemp;
	HKEY hKey;
	int i;

	// Pfad-Buffer lschen
	bfPath.Set (0,'\0');
	i =  0;
	// PfadNamen der Datenbasis aus der Registry ermitteln:
	if (RegOpenKeyEx (HKEY_LOCAL_MACHINE,"Software\\Panz\\Media Manager\\1.0",0,KEY_READ,&hKey) == ERROR_SUCCESS) {
		while (RegEnumValue (hKey,i,bfKey,&dwValueSize,NULL,&dwTemp,bfValue,&dwDataSize) == ERROR_SUCCESS) {
			if (strcmpi (bfKey,"Base") == 0)
				strcpy (bfPath,bfValue);
			if (strcmpi (bfKey,"Path") == 0)
         	m_stInstallPath = string (bfValue);
			dwValueSize = dwDataSize = MAX_PATH;
			i++;
		}
		RegCloseKey (hKey);
	}

	if (bfPath[0] == '\0') {
		// War das Laden aus der Registry erfolglos,
		// dann Pfad von Modul aus erzeugen

		strcpy (bfPath,pFileSys -> GetModulPath ());
		pFileSys -> AddSlash (bfPath);
		strcat (bfPath,PROPERTYBASEPATH);
	}

	// Pfad erzeugen:
	pFileSys -> CreatePath (bfPath);

	pFileSys -> AddSlash (bfPath);

	// Pfad in Klasse speichern:
	m_stPath = bfPath;

	m_pAktuell = NULL;
}

TPropertyBase::~TPropertyBase ()
{
	// Aktuell geladene Datei speichern
	if (m_pAktuell)
		delete m_pAktuell;
}


void TPropertyBase::SetValue (const char *cszForm,const char *cszComponent,const char *cszProperty,const char *cszValue)
{
	Lock (this);


	// Richtiges Formular laden, wenn eines angegeben
	if (cszForm != NULL) {
		LoadForm (cszForm);
		if (m_pAktuell)
			m_pAktuell -> SetEntry (cszComponent,cszProperty,cszValue);
	}
}


const char *TPropertyBase::GetValue (const char *cszForm,const char *cszComponent,const char *cszProperty)
{
	Lock (this);

	// Richtiges Formular laden, wenn eines angegeben
	if (cszForm != NULL) {
		LoadForm (cszForm);
		if (m_pAktuell)
			return m_pAktuell -> GetEntry (cszComponent,cszProperty,"");
	}

	return "";

}


// Datum aus Datenbasis entfernen
// Wenn als Key nur eine Komponenten angegeben wird,
// werden alle Daten dieser Komponente gelscht
// wird nur ein Formular angegeben, werden alle
// Forumlardaten gelscht.

void TPropertyBase::DelValue (const char *cszForm,const char *cszComponent,const char *cszProperty)
{
	Lock (this);

	// Richtiges Formular laden, wenn eines angegeben
	if (cszForm != NULL && cszForm[0] != '\0') {
		LoadForm (cszForm);
		if (cszComponent == NULL || cszComponent[0] == '\0')
		{ // Keine Komponente, also Formulardatei lschen
			if (m_pAktuell)
			{ // Datei aus Speicher entfernen
				m_pAktuell -> DontSave ();
				delete m_pAktuell;
				m_pAktuell = NULL;
				m_stAktuell = string ("");
			}
			remove (m_stFile.c_str());
			m_stFile = m_stAktuell = string ("");
		}
		else
		{
			if (cszProperty == NULL || cszProperty[0] == '\0')
			{ 	// Wenn keine Property angegeben,
				// gesamte Komponentendaten lschen:
				m_pAktuell -> DelSection (cszComponent);
			}
			else
			{	// Einen Property- Eintrag lschen:
				m_pAktuell -> DelEntry (cszComponent,cszProperty);
			}

		}

	}

}

// Formular laden:
void TPropertyBase::LoadForm (const char *cszForm)
{
	string stForm (cszForm);

	if (m_stAktuell != stForm)
	{ // nur, wenn Datei noch nicht geladen:
		TBuffer bfFile (MAXPATH);
		TBuffer bfPath (MAXPATH);

		// Aktuell geladene Datei entfernen:
		if (m_pAktuell)
			delete m_pAktuell;

		// Dateiname erzeugen
		strcpy (bfFile,m_stPath.c_str()); // Pfad
		strcat (bfFile,cszForm);	// Dateiname
		strcpy (bfPath,bfFile); // Zwischenergebnis zum Aufbau des Medien-Pfads benutzen
		strcat (bfFile,PROPERTYEXTENSION); // Extension

		// Medien-Pfad aufbauen
		strcat (bfPath,MEDIAPATH);
		// und merken
		m_stMediaPath = string (bfPath);

		// Daten-Datei laden
		m_pAktuell = new TINIFile (bfFile);

		m_stFile = bfFile; // Dateiname merken
		m_stAktuell = stForm; // Formularname der geladenen Datei merken


	}

}

unsigned TPropertyBase::GetKeyCount (const char *cszForm,const char *cszComponent)
{
	Lock (this);

	// Wurde Formular angegeben?
	if (cszForm == NULL || cszForm[0] == '\0')
	{ // nein, also die Anzahl der Formulare zurckgeben
		WIN32_FIND_DATA oFind;
		HANDLE hFind;
		TBuffer bfFindMask (MAX_PATH);
		unsigned uCount;

		// Suchmaske erzeugen
		strcpy (bfFindMask,m_stPath.c_str());
		strcat (bfFindMask,"*");
		strcat (bfFindMask,PROPERTYEXTENSION);

		hFind = FindFirstFile (bfFindMask,&oFind);

		if (hFind != INVALID_HANDLE_VALUE) {
			uCount = 1;
			while (FindNextFile (hFind,&oFind) == TRUE)
				uCount++;
			return uCount;
		} else
			return 0;
	}

	// Formular laden:
	LoadForm (cszForm);
	if (!m_pAktuell)
		return 0;

	if (cszComponent == NULL || cszComponent[0] == '\0') {
		// Anzahl der Komponenten eines Formulars liefern:
			return m_pAktuell -> GetSectionCount ();
	}
	// Anzahl der Propertys einer Komponenten liefern:
	return m_pAktuell -> GetKeyCount (cszComponent);
}


const char *TPropertyBase::GetKey (const char *cszForm,const char *cszComponent,unsigned uPos)
{
	Lock (this);

	// Wurde Formular angegeben?
	if (cszForm == NULL || cszForm[0] =='\0')
	{ // nein, also die Anzahl der
		WIN32_FIND_DATA oFind;
		HANDLE hFind;
		TBuffer bfFindMask (MAX_PATH);
		BOOL blCheck;
		char *c;

		// Suchmaske erzeugen
		strcpy (bfFindMask,m_stPath.c_str());
		strcat (bfFindMask,"*");
		strcat (bfFindMask,PROPERTYEXTENSION);

		hFind = FindFirstFile (bfFindMask,&oFind);

		if (hFind != INVALID_HANDLE_VALUE) {
			if (uPos > 0) { // wird erstes Element verlangt?
				// ber Dateien iterieren:
				do {
					blCheck = FindNextFile (hFind,&oFind);

					uPos--;
				} while (blCheck == TRUE && uPos > 0);

				// uPos -te Datei existiert nicht :
				if (blCheck == FALSE)
					return "";
			}
			// Formularname aus Dateiname erzeugen:
			c = oFind.cFileName;
			// 1. Extension entfernen
			for (uPos = strlen (c) -1;uPos > 0 && c [uPos] != '.';uPos--)
				; // hintersten Punkt suchen

			if (uPos > 0) { // gefunden oder emergency-stop?
				c [uPos] = '\0'; // und weg mit !

				// Pfadname von Dateiname trennen:
				for (;uPos > 0 && c [uPos] != '\\';uPos--)
					; // hintersten Backslash suchen
				if (uPos > 0) {
					m_stBuffer = string (c+uPos+1);
				} else {
					m_stBuffer = string (c);
				}
				return m_stBuffer.c_str ();
			}
		}
		return "";
	}

	// Formular laden:
	LoadForm (cszForm);

	if (!m_pAktuell) // Im Fehlerfall beenden:
		return "";

	if (cszComponent == NULL || cszComponent [0] == '\0') { // Komponenten eines Formulars abrufen?
		return m_pAktuell -> GetSectionName (uPos);
	}

	// Property- Name einer Komponente ermitteln
	return m_pAktuell -> GetKey (cszComponent,uPos);
}

// Formular umbenennen
// liefert bei Erfolg TRUE
BOOL TPropertyBase::RenameForm (const char *cszOldName,const char *cszNewName)
{
	Lock (this);

	WIN32_FIND_DATA oFind;
	HANDLE hFind;
	TBuffer bfFindMask (MAX_PATH);
	TBuffer bfNewFileName (MAX_PATH);

	// Suchmaske erzeugen
	strcpy (bfFindMask,m_stPath.c_str());
	strcat (bfFindMask,"*");
	strcat (bfFindMask,PROPERTYEXTENSION);

	// NewFileName erzeugen
	strcpy (bfNewFileName,cszNewName);
	strcat (bfNewFileName,PROPERTYEXTENSION);

	// erste Datei suchen
	hFind = FindFirstFile (bfFindMask,&oFind);

	if (hFind != INVALID_HANDLE_VALUE) {
		// ber Dateien iterieren:
		do {
			// ist NewName schon vorhanden ?
			if (strcmpi (oFind.cFileName,bfNewFileName) == 0)
				return FALSE; // ja
			// nchste Iteration :
		} while (FindNextFile (hFind,&oFind));
	}

	// OK, Name wird akzeptiert !

	// ist umzubennenende Datei gearde geladen?
	if (strcmpi (m_stAktuell.c_str(),cszOldName) == 0) {
		// Datei aus Speicher entfernen :
		if (m_pAktuell) {
			delete m_pAktuell;
			m_pAktuell = NULL;
			m_stAktuell = string ("");
		}
	}

	// Datei umbenennen:

	// 1. komplette Dateinamen erzeugen

	strcpy (bfFindMask,m_stPath.c_str()); // Old Name erzeugen
	strcat (bfFindMask,cszOldName);
	strcat (bfFindMask,PROPERTYEXTENSION);

	strcpy (bfNewFileName,m_stPath.c_str());
	strcat (bfNewFileName,cszNewName);
	strcat (bfNewFileName,PROPERTYEXTENSION);

	// Datei umbennen
	rename (bfFindMask,bfNewFileName);

	// Medien-Verzeichis umbennen
	strcpy (bfFindMask,m_stPath.c_str()); // Old Name erzeugen
	strcat (bfFindMask,cszOldName);
	strcat (bfFindMask,MEDIAPATH);
	// Abschlieenden Bachslash entfernen:
	bfFindMask.Set (strlen (bfFindMask)-1,'\0');

	strcpy (bfNewFileName,m_stPath.c_str());
	strcat (bfNewFileName,cszNewName);
	strcat (bfNewFileName,MEDIAPATH);
	// Abschlieenden Bachslash entfernen:
   bfNewFileName.Set (strlen (bfNewFileName)-1,'\0');
	// Path umbennen
	rename (bfFindMask,bfNewFileName);



	return TRUE;
}

// Componente umbenennen
// liefert bei Erfolg TRUE
BOOL TPropertyBase::RenameComponent (const char* cszForm,const char *cszOldName,const char *cszNewName)
{
	Lock (this);
	// Formular laden:
	LoadForm (cszForm);

	if (m_pAktuell)
		return m_pAktuell -> RenameSection (cszOldName,cszNewName);
	else
		return FALSE;

	return TRUE;
}


// Pfad fr Medien-Dateien ermitteln
const char* TPropertyBase::GetMediaPath (const char *cszForm)
{
	Lock (this);
	// Formular laden:
	LoadForm (cszForm);

	const char *cszMediaPath = m_stMediaPath.c_str();

	// MedienPfad erst erzeugen wenn er nachgefragt wird:
	pFileSys -> CreatePath (cszMediaPath);

	// und Pfadname zurck liefern
	return cszMediaPath;
}

void TPropertyBase::Save (void)
{
	Lock (this);

	if (m_pAktuell) {
		delete m_pAktuell;
		m_pAktuell = NULL;
		m_stAktuell = string ("");
	}

}


const char *TPropertyBase::GetInstallPath (void)
{
	return m_stInstallPath.c_str();
}
