//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Haupt- Header Datei
//*******************************

#define WIN32_LEAN_AND_MEAN
#define STRICT

// Laufzeit-Bibliothek includes
#include <stdio.h>

// Library's Header
#include <inifile.h>
#include <filesys.h> // ehemals FileHelp

#include <classlib\thread.h>

//*******************************
//	 TPropertyBase
//*******************************
//  Verwaltung der Delphi
//	 Property- Daten
//*******************************

// Aufbau eines Keys:
// Formular:Component:Property

#define PROPERTYEXTENSION ".PropBase"
#define PROPERTYBASEPATH "MediaMan DataBase"
#define MEDIAPATH " Media\\"

class TPropertyBase : private TSync
{
	private :

		TINIFile *m_pAktuell; // Aktueller Zugriff
		string m_stAktuell; // Formularname der aktuell geladenen Daten-Datei

		// Pfad-Daten
		string m_stPath; // Datenbasis-Pfad mit abschliedendem Backslash
							// wird im Konstruktor erzeugt

		string m_stFile; // Dateiname der geladenen Datei

		string m_stBuffer; // Buffer fr Datenrckgabe

		string m_stMediaPath; // Buffer fr Medien-Pfad des akt, geladenen Formulars

      string m_stInstallPath; // Installationspfad des Media-Managers

	protected :

		// Formular laden:
		void LoadForm (const char *cszForm);

	public :

		TPropertyBase (void);
		~TPropertyBase ();

		// Datum in Datenbasis einfgen/ ndern
		// nicht vorhandene Keys werden erzeugt
		void SetValue (const char *cszForm,const char *cszComponent,const char *cszProperty,const char *cszValue="");

		// Datum aus Datenbasis abrufen
		// Ist Key nicht existent, wird "" zurckgeliefert.
		const char *GetValue (const char *cszForm,const char *cszComponent,const char *cszProperty);

		// Datum aus Datenbasis entfernen
		// Wenn als Key nur eine Komponenten angegeben wird,
		// werden alle Daten dieser Komponente gelscht
		// wird nur ein Formular angegeben, werden alle
		// Forumlardaten gelscht.
		void DelValue (const char *cszForm,const char *cszComponent=NULL,const char *cszProperty=NULL);

		// Cursor- Zugriffe
		unsigned GetKeyCount (const char *cszForm=NULL,const char *cszComponent=NULL);
		const char *GetKey (const char *cszForm,const char *cszComponent, unsigned uPos);

		// Formular umbenennen
		// liefert bei Erfolg TRUE
		BOOL RenameForm (const char *cszOldName,const char *cszNewName);

		// Componente umbenennen
		// liefert bei Erfolg TRUE
		BOOL RenameComponent (const char *cszForm,const char *cszOldName,const char *cszNewName);

		// Pfad fr Medien-Dateien ermitteln
      // mit abschlieendem Backslash !
		const char* GetMediaPath (const char *cszForm);

		void Save (void);

      const char *GetInstallPath (void);

};





