//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Verwaltung der Delphi
//   Property- Daten
//*******************************
#include <propbase.h>
#include <propmain.h>

static TPropertyBase *pBase=NULL;
TFileSys *pFileSys=NULL;
static DWORD uAttachCounter= 0;


BOOL WINAPI DllEntryPoint(

	 HINSTANCE  hinstDLL,	// handle of DLL module
	 DWORD  fdwReason,	// reason for calling function
	 LPVOID  /*lpvReserved*/ 	// reserved
	)
{

	switch (fdwReason) {
		case DLL_PROCESS_ATTACH :
		case DLL_THREAD_ATTACH :
		// Dll-Daten init wenn ntig:
			if (uAttachCounter == 0) {
				pFileSys = new TFileSys (hinstDLL);
				pBase = new TPropertyBase ();
			}
			uAttachCounter++;
			break;
		case DLL_THREAD_DETACH :
		case DLL_PROCESS_DETACH :
			uAttachCounter--;
			if (pBase)
				pBase -> Save();

			if (uAttachCounter == 0) {
				if (pBase) {
					delete pBase;
					pBase = 0;
				}
				if (pFileSys) {
					delete pFileSys;
					pFileSys = 0;
				}
			}
			break;

	}
	return TRUE;
}

void FAR PASCAL _export PBSetValue (const char* cszForm,const char* cszComponent,
											 const char* cszProperty,const char* cszValue)
{
	if (pBase)
		pBase -> SetValue (cszForm,
							 cszComponent,
							 cszProperty,
							 cszValue);
}

const char * FAR PASCAL _export PBGetValue (const char* cszForm,const char* cszComponent,
														const char* cszProperty)
{
	if (pBase)
		return pBase -> GetValue (cszForm,
									  cszComponent,
									  cszProperty);
	else
		return "";
}

void FAR PASCAL _export PBDelValue (const char* cszForm,const char* cszComponent,const char* cszProperty)
{
	if (pBase)
		pBase -> DelValue (cszForm,cszComponent,cszProperty);
}

DWORD FAR PASCAL _export PBGetKeyCount (const char* cszForm,const char* cszComponent)
{
	if (pBase)
		return pBase -> GetKeyCount (cszForm,cszComponent);
	else
		return 0;
}

const char* FAR PASCAL _export PBGetKey (const char *cszForm,const char *cszComponent,DWORD uPos)
{
	if (pBase)
		return pBase -> GetKey (cszForm,cszComponent,uPos);
	else
		return "";

}

BOOL FAR PASCAL _export PBRenameForm (const char* cszOldName,const char* cszNewName)
{
	if (pBase)
		return pBase -> RenameForm (cszOldName,cszNewName);
	else
		return FALSE;
}

BOOL FAR PASCAL _export PBRenameComponent (const char* cszForm,const char* cszOldName,const char* cszNewName)
{
	if (pBase)
		return pBase -> RenameComponent (cszForm,cszOldName,cszNewName);
	else
		return FALSE;
}

const char* FAR PASCAL _export PBGetMediaPath (const char* cszForm)
{
	if (pBase)
		return pBase -> GetMediaPath (cszForm);
	else
		return "";
}

const char* FAR PASCAL _export PBGetInstallPath (void)
{
	if (pBase)
		return pBase -> GetInstallPath ();
	else
		return "";
}

