//*******************************
//   Media- Manager
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//   Picture - Converter
//  Bilder-Konverter
//*******************************
#include <mmpiconv.h>

#define DDESERVICENAME "MediaManager"
#define CONVERT "PictureConvert"
DWORD dwDdeInstance=0;

//*******************************
//  TDdeString
//*******************************
class TDdeString
{
	private :

		HSZ hString;
		string stString;
		BOOL blDelHSZ; // Soll HSZ im Destruktor gelscht werden?

	public :

		TDdeString (const char *szString) : stString (szString) { hString = DdeCreateStringHandle (dwDdeInstance,szString,CP_WINANSI); blDelHSZ = TRUE;}

		// Konstruktor fr DDE-String-Handle:
		TDdeString (HSZ hSz) { 	hString = hSz;
										blDelHSZ = FALSE;
										unsigned u = DdeQueryString (dwDdeInstance,hSz,NULL,NULL,CP_WINANSI);
										TBuffer bfString (u+2);
										DdeQueryString (dwDdeInstance,hSz,bfString,u+1,CP_WINANSI);
										stString = bfString; }

		~TDdeString () { if (blDelHSZ == TRUE) DdeFreeStringHandle (dwDdeInstance,hString); }

		// Zugriff:
		operator HSZ() { return hString; }
		operator const char*() { return stString.c_str (); }
		// Vergleich:
		friend int operator== (TDdeString& oString1,TDdeString& oString2);
		friend int operator== (HSZ hSz,TDdeString& oString);
};


//*******************************
//  TDdeString
//*******************************
// Operatoren
//*******************************
int operator== (TDdeString& oString1,TDdeString& oString2)
{
	return (DdeCmpStringHandles (oString1.hString,oString2.hString) == 0);
}

int operator== (HSZ hSz,TDdeString& oString)
{
	return (DdeCmpStringHandles (hSz,oString.hString) == 0);
}

HDDEDATA CALLBACK  DdeCallback(
	 UINT  uType,	// transaction type
	 UINT  /*uFmt*/,	// clipboard data format
	 HCONV  /*hConv*/,	// handle of the conversation
	 HSZ  hSz1,	// handle of a string
	 HSZ  hSz2,	// handle of a string
	 HDDEDATA  /*hData*/,	// handle of a global memory object
	 DWORD  /*dwData1*/,	// transaction-specific data
	 DWORD  /*dwData2 */	// transaction-specific data
	)
{
	static int Count = 0;

	switch (uType) {
		case	XTYP_CONNECT :
			if (hSz2 == TDdeString (DDESERVICENAME)) { // Stimmt Service?
				if (hSz1 == TDdeString (CONVERT)) { // Komonenten Topic?
					return (HDDEDATA)TRUE;
				}
			}
			return (FALSE);
		case XTYP_CONNECT_CONFIRM :
		{
			Count ++; // Verbindungszhler hochzhlen
			break;
		}
		case XTYP_REQUEST :
		{
			// Befehlsstring ermitteln
			TDdeString oDDECmd (hSz2);

			TBuffer bfSource (MAX_PATH),bfDest (MAX_PATH),bfForm (MAX_PATH);
			int iDither,iWidth,iHeight,iTrans;
			char *c;
		
			// in einen bearbeitbaren Buffer
			TBuffer bfCmd (oDDECmd);

			// Parameter auslesen:

			// 1. Source File:
			c = strtok (bfCmd,"|");
			if (c) {
				strcpy (bfSource,c);

				// 2. Dithering
				c = strtok (0,"|");
				if (c) {
						iDither = atoi (c);

					// 3. Width
					c = strtok (0,"|");
					if (c) {
						iWidth = atoi (c);

						// 4. Height
						c = strtok (0,"|");
						if (c) {
							iHeight = atoi (c);

							// 5. Transparency
							c = strtok (0,"|");
							if (c) {
								iTrans = atoi (c);

								// 6. destination file
								c = strtok (0,"|");
								if (c) {
									strcpy (bfDest,c);

									// 7. Formularname
									c = strtok (0,"|");
									if (c) {
										strcpy (bfForm,c);
										if (pDialog) // isr zeiger auf konvertierungsdialog gltig?
											pDialog -> Convert (bfSource,iDither,iWidth,iHeight,iTrans,bfDest,bfForm); // und konvertieren
									}
								}
							}
						}
					}
				}
			}
			return NULL; // alles in Butter!
		}
		case XTYP_DISCONNECT :
		{
			Count--;
			if (Count == 0) {
				if (pDialog)	// Applikation beenden
					pDialog -> CmOk ();
			}
			return (HDDEDATA)TRUE;
		}
	}
	return NULL;
}


//*******************************
// 	TPictureConverter
//*******************************
// Dialog
//*******************************
TPictureConverter::TPictureConverter (void)
	: TDialog (0,ConvertDLG),
	  m_oLead (this,DLG_1),
	  m_oGauge (this,DLG_2)

{
	UINT iRet;
	HDDEDATA hRet;

	pDialog = this;
	iRet = DdeInitialize (&dwDdeInstance,
					DdeCallback,
					APPCLASS_STANDARD | APPCMD_FILTERINITS,0L);
	if (iRet != DMLERR_NO_ERROR) {
		MessageBox ("Can't initialize DDE. Please check installation.","Error",MB_OK | MB_ICONHAND);
	} else {
		hRet = DdeNameService (dwDdeInstance,TDdeString (DDESERVICENAME),
					NULL,
					DNS_FILTERON | DNS_REGISTER);
		if (hRet == 0) {
			MessageBox ("Can't initialize DDE-Nameservice. Please check installation.","Error",MB_OK | MB_ICONHAND);
		}
	}

}

TPictureConverter::~TPictureConverter ()
{
	if (dwDdeInstance != 0) {
		DdeUninitialize (dwDdeInstance);
      dwDdeInstance = 0;
	}
}


DEFINE_RESPONSE_TABLE2 (TPictureConverter,TWindow,TVbxEventHandler)
END_RESPONSE_TABLE;


void TPictureConverter::Convert (const char *cszSource,
											int iDither,
											int iWidth,
											int iHeight,
											int iTransColor,
											const char *cszDestFile,
											const char *cszForm)
{
	// Bild konverieren
	TBuffer bfConvert (37);
	TBuffer bfFile83 (MAX_PATH),bfSource (MAX_PATH);
	COLORREF oPal [256];
	TBmp oDib;
	PBYTE pData;
	BYTE *pbyMask=NULL;
	int i,j,w,h;
	HDC hDC;
	HWND OldFocus;

	void *pAssign;

	// Dialog anzeigen
	Parent -> ShowWindow (SW_SHOWNORMAL);
	ShowWindow (SW_SHOWNORMAL);

	OldFocus = SetFocus ();
	UpdateWindow ();

	// Palette laden:
	pAssign = MMOpenMedia (cszForm);
	MMGetMedia (pAssign,1,&oPal,sizeof (oPal));
	MMCloseMedia (pAssign);




	if (*cszSource != '\0') {
		// 8:3 Name ermitteln
		strcpy (bfFile83,pFileSys -> Get83Name (cszSource));

		// Gauge auf 0 %
		m_oGauge.SetPropValue (0);
		UpdateWindow ();

		m_oLead.SetPropBackPalette (FALSE);
		m_oLead.SetPropFile (bfFile83);
		m_oLead.SetPropRepaint (TRUE);

		// Transparenz-Maske erzeugen
		if (iTransColor != -1) {
			// Datei laden

			// Gre ohne Interpolation anpassen
//			m_oLead.SetPropResizeType (TVbxLEADBitmap::ResizeType_1_Interpolate); // Interpolierend die Gre ndern
			m_oLead.SetPropResizeType (TVbxLEADBitmap::ResizeType_0_Normal); // Interpolierend die Gre ndern
			m_oLead.SetPropResizeWidth (iWidth);
			m_oLead.SetPropResizeHeight (iHeight);
			m_oLead.SetPropResize (TRUE);

			// Speicher fr Maske allocieren
			pbyMask = (unsigned char*) malloc (iWidth * iHeight);
			m_oLead.SetPropBitmapDC (TRUE);
			m_oLead.GetPropBitmapDC (i);
			hDC = (HDC)i;

			// Maske erzeugen
			for (i=0;i< iHeight;i++) {
				for (j=0;j < iWidth;j++) {
					if (GetPixel (hDC,j,i) == iTransColor) {
						pbyMask [i*iWidth + j] = 255;
					} else {
						pbyMask [i*iWidth + j] = 0;
					}
				}
			}

			m_oLead.SetPropBitmapDC (FALSE);

			// Neu laden:
			m_oLead.SetPropBackPalette (FALSE);
			m_oLead.SetPropFile (bfFile83);

		}

		// 10% Arbeitsfortschritt
		m_oGauge.SetPropValue (10);
		UpdateWindow ();

		// 40% Arbeitsfortschritt
		m_oGauge.SetPropValue (40);
		UpdateWindow ();

		// Gre anpassen
		m_oLead.SetPropResizeType (TVbxLEADBitmap::ResizeType_1_Interpolate); // Interpolierend die Gre ndern
		m_oLead.SetPropResizeWidth (iWidth);
		m_oLead.SetPropResizeHeight (iHeight);
		m_oLead.SetPropResize (TRUE);

		// 70% Arbeitsfortschritt
		m_oGauge.SetPropValue (70);
		UpdateWindow ();

		// Palette von BGR auf RGB konvertieren:
		for (i=0;i <256;i++)
			oPal[i] =(COLORREF)(int)  ( oPal[i] & 0x00ff00) |
							((oPal[i] & 0xff0000) >> 16) |
							((oPal[i] & 0x0000ff) << 16);


		// Palette in User-Palette der  VBX bertragen:
		for (i=0;i<256;i++)
			m_oLead.SetPropBitChgUserPal (oPal[i],i);

		// Hintergrund setzen:
		m_oLead.SetPropBackColor( oPal[0]);

		// Dithering einleiten
		m_oLead.SetPropBitChgPalette (TVbxLEADBitmap::BitChgPalette_2_User);
		m_oLead.SetPropBitChgDither ((short)iDither);
		m_oLead.SetPropBitmapBits (8);

		// Transparenz per Maske ins Bild rechnen

		strcpy (bfSource,pFileSys -> Get83Name (pFileSys -> GetModulPath()));
		pFileSys -> AddSlash (bfSource);
		strcat (bfSource,"PicEdit.BMP");

		// evt. alte Version lschen:
		remove (bfSource);

		// Bitmap speichern
		m_oLead.SetPropSaveBits (8);
		m_oLead.SetPropSaveFormat (TVbxLEADBitmap::SaveFormat_7_Windows_Bitmap);
		m_oLead.SetPropSaveFile (bfSource);
//			MessageBox (bfSource,"Can't Save");

		// Bitmap wieder laden
		if (oDib.Load (bfSource) == TRUE) {

			// bearbeiten..
			// Wichtig: dabei mssen die Dimensionen der geladenen Datei verwendet werden
			// Sicher ist sicher!!!
			w = oDib.GetWidth();
			h = oDib.GetHeight ();

			for (i=0;i < h;i++) {
					pData = (PBYTE) oDib.GetPixelAddress (0,i);
				for (j=0;j < w;j++) {
					if (!(pData[j]))
						pData[j] = 255;
					if (pbyMask && pbyMask [i* w + j])
						pData[j] = 0;
				}
			}
			// und als Bitmap zum Bearbeiten speichern
			oDib.Save (bfSource);
			oDib.SaveBits (cszDestFile);
		}

		// 100% Arbeitsvortschritt
		m_oGauge.SetPropValue (100);
		UpdateWindow ();
	}

	// Dialog ausblenden
	Parent -> ShowWindow (SW_HIDE);
	::SetFocus (OldFocus);
}

