// Dynamische String- Buffer-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4
//		21436 Marschacht
//
// Datei: Buffers.h
//
// Bereitstellen von dynamischen TBuffern der Gre BUFSIZE
// Zugriff ber char* - Castingoperatoren

#ifndef BUFFERS
	#ifndef BUFSIZE
		#define BUFSIZE 512
	#endif

	#define BUFFERS

	#ifdef __BCPLUSPLUSx__
		#include <cstring.h>
	#else
		#include <string.h>
	#endif

	class TBuffer
	{
		private :

			char *m_szBuf;

		public :

			TBuffer (int i = BUFSIZE)
				{ m_szBuf = new char [i]; }
			TBuffer (const char *b)
				{ m_szBuf = new char [strlen (b)+1]; strcpy (m_szBuf,b); }
			~TBuffer () { if (m_szBuf) delete m_szBuf; }

			operator char * ()
				{ return m_szBuf; }
			operator LPBYTE ()
				{ return (LPBYTE)m_szBuf; }
			char operator [] (int i)
				{ return m_szBuf [i]; }
			operator long () 
				{ return (long) m_szBuf; }

			#ifdef __CSTRING_H
				operator string () 
					{return string (m_szBuf); }
			#endif

			void Set (int pos,char c) 
				{ m_szBuf [pos] = c; }
			void Clr (void) 
				{ *m_szBuf = '\0'; }
	};
#endif

