//*******************************
//   File-System Funktionen
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//  Implementierung
//*******************************
// Klasse ist bereit fr
// Multitasking und - threading
// Bereit fr lange Dateinamen
//*******************************


#define STRICT
#include <windows.h>

#include <classlib\arrays.h> // ld std. Windows.H

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include "Buffers.h"
#include <lzexpand.h>
#include <shlobj.h>

#define IMPEX _export
#include <filesys.h>


 // Windows-Directory
static char szWindowsPath [MAXPATH+1] = "";
// Temporres Directory
static char szTempPath [MAXPATH+1] = "";


TFileSys::TFileSys (HINSTANCE hInst)
{
	// Statics init:
	if (*szWindowsPath == '\0') { // nur, wenn noch nicht geschehen:
		// Windows Directory ermitteln
		GetWindowsDirectory (szWindowsPath,MAXPATH);
		// Temporres Direktory ermitteln
		GetTempPath (MAXPATH,szTempPath);
	}
	// Instanz merken:
	hInstance = hInst;

	// Modulpfad ermitteln:
	if (hInstance != NULL) {	// Instanz mu0 gltig sein:
		GetModuleFileName (hInstance,m_szPath,MAXPATH);

		Split (m_szPath);     // In Bestandteile aufteilen
		m_szFile[0] = '\0';	// Dateiname lschen
		m_szExt [0] = '\0';	// Extension lschen
		Merge ();			// wieder zusammenfgen
		strcpy (m_szModulPath,m_szPath);
	}
}

// Aufteilung eines Pfadnamens in die Komponenten
int TFileSys::Split (const char * path)
{
	return fnsplit (path,m_szDrive,m_szDir,m_szFile,m_szExt);
}

void TFileSys::Merge (void)
{
	fnmerge (m_szPath,m_szDrive,m_szDir,m_szFile,m_szExt);
}

// evt. Backslash am Ende wird gelscht
char *TFileSys::NoEndingSlash (const char *cszPath)
{
	int i;

	if (cszPath != m_szPath)
		lstrcpy (m_szPath,cszPath);


	i = lstrlen (m_szPath) -1;

	if (m_szPath[i] == '\\')
		m_szPath[i] = '\0';

	return m_szPath;
}


// Ermittelt aus einem Dateinamen den Pfad
char *TFileSys::ExtractPath (const char *cszFilename)
{

	if (strchr (cszFilename,'.') != NULL) {	// Nur extrahieren, wenn Extension-Punkt vorhanden
		Split (cszFilename);	// Filename+Pfad aufsplitten
		m_szFile [0] = '\0';	// Filename lschen
		m_szExt [0] = '\0';	// Extension lschen
		Merge ();			// wieder zusammensetzen
	} else
		if (m_szPath != cszFilename)
			lstrcpy (m_szPath,cszFilename);

	return m_szPath;		// Ergebnis zurckliefern
}

// Dateiname extrahieren
char *TFileSys::ExtractFilename (const char *cszPathFile)
{
	Split (cszPathFile);		// Path zerlegen
	strcpy (m_szPath,m_szFile); // Dateiname
	strcat (m_szPath,m_szExt);	// und Extension zusammenkopieren

	return m_szPath;		// und zurckliefern
}

// Liefert TRUE, wenn Pfad existiert
int TFileSys::PathExist (const char *cszPath)
{
	if (lstrlen (cszPath) <= 3) { 	// Nur Laufwerk-Angabe vorhanden
#ifdef __MSDOS__
		if (GetDriveType (toupper(*cszPath)-'A') == 0)
#else
		if (GetDriveType ((LPCTSTR)cszPath) == 0)
#endif
			return FALSE;
		else
			return TRUE;
	}

	if (access (NoEndingSlash (cszPath),0) == 0)
		return TRUE;
	else
		return FALSE;
}


int TFileSys::FileAccess (const char *cszFile)
{
	if (FileExist (cszFile) == TRUE) { // Wenn File vorhanden, prfen ob Zugriff erlaubt
		if (access (cszFile,2) == 0)
			return TRUE;
		else
			return FALSE;
	} else {			// Wenn File nicht vorhanden, prfen ob Pfad vorhanden
		Split (cszFile);
		m_szFile [0] = '\0';
		m_szExt [0] = '\0';
		Merge ();
		return PathExist (m_szPath);
	}
}


int TFileSys::FileExist (const char *cszFile)
{
	if (access (cszFile,4) == 0)
		return TRUE;
	else
		return FALSE;
}

 // Liefert gltigen Pfad auf Filename1, Filename2 oder Windowsverzeichnis
char *TFileSys::TraceValidPath (const char *cszFilename1,const char *cszFilename2)
{
	const char *c;

	c = szWindowsPath;

	if (PathExist (ExtractPath (cszFilename1)) == TRUE) {	// Ist der Pfad von Filename1 gltig?
		c = cszFilename1;
	} else {
		if (cszFilename2 != NULL) {
			if (PathExist (ExtractPath (cszFilename2)) == TRUE)	// Ist der Pfad von Filename2 gltig?
				c = cszFilename2;
		}
	}

	lstrcpy (m_szPath,c);

	return m_szPath;		// Ansonsten das Windowsverzeichnis bergeben
}

// kpl. Pfad des ak. Pfad ermitteln
// drive:  'a' || 'A'
char *TFileSys::GetDirFromDrive (char cDrive)
{
	// Laufwerkangabe erzeugen
	lstrcpy (m_szPath,"x:\\");
	m_szPath [0] = (char)toupper (cDrive);

	getcurdir (m_szPath[0]-'A'+1,&m_szPath[3]);

	return m_szPath;
}


int TFileSys::CreatePath (const char *cszPath)
{
	ffblk ff;
	char *c,flag=0;

	TBuffer bfPath (cszPath);

	AddSlash (bfPath);
	for (c=strchr (bfPath,'\\')+1;*c != 0;c++) {
		if (*c == '\\') {
			*c = '\0';
			if ((findfirst (bfPath,&ff,FA_DIREC))!=0)
				if (mkdir (bfPath) == EOF)
					return 0;
			*c = '\\';
				flag = 1;
		}
	}
	if (flag == 0 && *(c-2) != ':')
		if (findfirst (bfPath,&ff,FA_DIREC) != 0)
			return FALSE;
	return TRUE;
}


char *TFileSys::AddSlash (char *szName)
{
	unsigned i;

	i = lstrlen (szName);

	if (i == 1)			// nur Laufwerksbuchstabe
		lstrcat (szName,":\\");
	else if (szName [i-1] != '\\')
		lstrcat (szName,"\\");

	return szName;
}

char *TFileSys::ExtractMinPath (const char *cszFilename,const char *cszPath,int iAnzahl)
{
	int i;
	const char *c;

	if (m_szPath != cszPath)
		lstrcpy (m_szPath,cszPath);

	AddSlash (m_szPath);

	for (i=0;toupper (m_szPath[i]) == toupper (cszFilename[i]) && cszFilename[i] != '\0' && m_szPath [i] != '\0';i++)
		;

	if (cszFilename[i] == '\0')
		c = "";
	else if (m_szPath[i] == '\0')
		c =  cszFilename + i;
	else
		c = cszFilename;

	if (lstrlen(c) > iAnzahl)  { 	// Wenn Dateiname zu lang fr Darstellung
		Split (c);
		lstrcpy (m_szDir,"\\..\\");
		Merge ();
		c = m_szPath;
	}

	if (c != m_szPath) {
		strcpy (m_szPath,c); // Erg in m_szPath kopieren
	}

	return m_szPath;

}

// Anhand des alten Names eine Tempdatei im Temp-Verzeichnis erstellen
char *TFileSys::CreateTempFilename (const char *cszOldName)
{
	return SetNewPathExt (cszOldName,szTempPath,".TMP");
}

// Filename aus OrgName mit NewPath und NewExt zu einem Pfad+Filename verarbeiten
char *TFileSys::SetNewPathExt (const char *cszOrgName,const char *cszNewPath,const char *cszNewExt)
{
	Split (cszOrgName);
	lstrcpy (m_szPath,cszNewPath);
	AddSlash (m_szPath);
	lstrcat (m_szPath,m_szFile);
	lstrcat (m_szPath,cszNewExt);

	return m_szPath;
}

 // Extension ndern
char * TFileSys::SetNewExt (const char *cszOldName,const char *cszExt)
{
	Split (cszOldName);
	lstrcpy (m_szExt,cszExt);
	Merge ();
	return m_szPath;
}


// Pfad und Filename zusammenbringen
char * TFileSys::AddPathFile (const char * cszPath,const char *cszFile)
{
	TBuffer dr (MAXPATH),di (MAXPATH);

	strcpy (di,cszPath);
	AddSlash (di);

	Split (di);
	lstrcpy (dr,m_szDrive);
	lstrcpy (di,m_szDir);

	Split (cszFile);

	lstrcpy (m_szDrive,dr);
	lstrcpy (m_szDir,di);

	Merge ();
	return m_szPath;
}

// Pfad des ausgefhrten Moduls ermitteln
char * TFileSys::GetModulPath (void)
{
	if (hInstance == NULL)		// Wenn Instanzenhandle nicht angegeben wurde ist Funktion
		return "";
	else
		return m_szModulPath;
}

// System-Direktory ermitteln
char * TFileSys::GetSystemPath (void)
{
	GetSystemDirectory (m_szPath,MAXPATH);
	return m_szPath;
}

// Absoluten File/Pfad in relativen Pfad relativ zu "Pfad" konvertieren
char *TFileSys::GetRelPath (const char * cszFile,const char * cszPath)
{
	TBuffer bfDrive (MAXPATH+1),bfDir (MAXPATH+1);
	char *c,*d,*ls;
	unsigned u;


	// Fall: f ist schon relativ und nicht absolut:
	if (strchr (cszFile,':') == 0 && *cszFile != '\\') {
		strcpy (m_szPath,cszFile);
		return m_szPath;
	}

	strcpy (m_szPath,cszPath);
	AddSlash(m_szPath);
	Split (m_szPath);	// Pfad aufsplitten
	strcpy (bfDrive,m_szDrive); // und sichern
	strcpy (bfDir,m_szDir);

	Split (cszFile);	// Datei aufsplitten

	// Stimmt Drive berein?
	if (strcmpi (m_szDrive,bfDrive) != 0 && *m_szDrive != '\0') {  // Nein, also rel-Path = abs-Path
		strcpy (m_szPath,cszFile);
		return m_szPath;
	}

	// Stimmt Dir berein?
	if (strcmpi (m_szDir,bfDir) == 0) {    // JA, Dateiname = rel-Path
		strcpy (m_szPath,m_szFile);
		strcat (m_szPath,m_szExt);
		return m_szPath;
	}

	// Pfade von vorne her vergleichen

	c = bfDir;
	d = m_szDir;
	ls = NULL;

	while (*c != '\0' && *d != '\0') {
		if (*c != *d)
			break;
		if (*c == '\\')
			ls = c;
		c++;
		d++;
	}
	if (ls == NULL) {	// Kein Backslash innerhalb der bereinstimmung
		strcpy (m_szPath,cszFile);
		return m_szPath;
	}

	// d zeigt auf Restpfad

	// Backslash in *c zhlen
	for (u=0;*c != '\0';c++)
		if (*c == '\\')
			u++;

	// ..\\ u-mal vor rel. Pfad einfgen
	m_szPath[0] = '\0';

	while (u != 0) {
		strcat (m_szPath,"..\\");
		u--;
	}
	strcat (m_szPath,d);
	AddSlash (m_szPath);
	strcat (m_szPath,m_szFile);
	strcat (m_szPath,m_szExt);

	return m_szPath;
}

// Relativen File/Pfad in absoluten Pfad konvertieren
char *TFileSys::GetAbsPath (const char *cszFile,const char * cszPath)
{
	unsigned u,i,j;
	static const char tst [] = "..\\";
	const char *c;

	// Ist File schon Absolut?
	if (strchr (cszFile,':')) {
		strcpy (m_szPath,cszFile);
		return m_szPath;
	}

	// Geht der relative Pfad direkt vom absoluten Pfad aus?
	if (cszFile[0] != '\\' && cszFile[0] != '.') {
		strcpy (m_szPath,cszPath);
		AddSlash (m_szPath);
		strcat (m_szPath,cszFile);

		return m_szPath;
	}

	if (cszFile[0] == '\\')	{	// Nur Laufwerk identisch?
		TBuffer buf (MAXPATH+1);

		Split (cszPath);
		strcpy (buf,m_szDrive);
		Split (cszFile);
		strcpy (m_szDrive,buf);
		Merge ();

		return m_szPath;
	}

	u = 0;
	j = 1;
	c = cszFile;
	do {
		for (i=0;i <3;i++) {
			if (*c != tst[i]) {
				j = 0;
				break;
			}
			c++;
		}
		if (j)
			u++;
	} while (j);

	strcpy (m_szPath,cszPath);
	NoEndingSlash (m_szPath);

	i = strlen (m_szPath)-1;
	// Pfad verkleinern
	while (u) {
		while (i > 0 && m_szPath[i] != '\\' && m_szPath[i] != ':')
			i--;
		if (i == 0) {
			strcpy (m_szPath,cszFile);
			return m_szPath;
		}
		if (m_szPath [i] == ':') {
			m_szPath[i+1] = '\\';
			m_szPath[i+2] = '\0';
			strcat (m_szPath,c);
			return m_szPath;
		}
		i--;
		u--;
	}
	m_szPath [i+2] = '\0';
	strcat (m_szPath,c);

	return m_szPath;
}

BOOL TFileSys::SaveResource (const char *cszResType,unsigned uResID,const char *cszFilename)
{
	HRSRC hRes;
	hRes = FindResource (hInstance,
			MAKEINTRESOURCE (uResID),
			cszResType);
	if (hRes)
		return SaveResource (hRes,cszFilename);

	return FALSE;
}

BOOL TFileSys::SaveResource (HRSRC hRes,const char *cszFilename)
{
	HCURSOR hOldCursor = SetCursor (LoadCursor (NULL,IDC_WAIT)); // Mauszeiger auf Wait setzen

	OFSTRUCT *pOpenFile;
	HFILE hFile;
	BOOL ok = FALSE;

	pOpenFile = new OFSTRUCT ();

	if (hRes != 0) {
		hFile = OpenFile (cszFilename,pOpenFile,OF_CREATE);
		if (hFile != HFILE_ERROR ) {
			const void far *data;
			unsigned long offset=0,size,delta;
			HGLOBAL hg;

			size = SizeofResource (hInstance,hRes);
			hg = LoadResource (hInstance,hRes);
			data = LockResource (hg);
			if (data != NULL) {
				while (offset < size) {
					if ((size - offset) > 65535L)
						delta = 65535L;
					else
						delta = size - offset;
					_lwrite (hFile,(LPCSTR)data,(unsigned)delta);
					offset += delta;
				}
				ok = TRUE;
				UnlockResource (hg);
			}
			FreeResource (hg);
		}
		_lclose (hFile);
	}

	delete pOpenFile;

	SetCursor (hOldCursor); // Cursor zurcksetzen
	return ok;
}

// Windows-Pfad zurckgeben
char *TFileSys::GetWinPath (void)
{
	return szWindowsPath;
}

BOOL TFileSys::SaveResource (unsigned uResType,unsigned uResID,const char *cszFilename)
{
	return SaveResource (MAKEINTRESOURCE (uResType),uResID,cszFilename);
}


char *TFileSys::Get83Name (const char *cszLongName)
{
	WIN32_FIND_DATA oData;
	TBuffer bfPath (cszLongName);
	HANDLE hResult;
	char *c;

	AddSlash (bfPath);

	// Laufwerksbuchstaben in Ergebnisstring kopieren
	memcpy (m_szPath,cszLongName,2);
	m_szPath [2] = '\0';

	for (c=strchr (bfPath,'\\')+1;*c != 0;c++) {
		if (*c == '\\') {
			*c = '\0';
			hResult = FindFirstFile (bfPath,&oData);

			if (hResult != INVALID_HANDLE_VALUE) {
				strcat (m_szPath,"\\");
				if (oData.cAlternateFileName [0] != '\0')
					strcat (m_szPath,oData.cAlternateFileName);
				else
					strcat (m_szPath,oData.cFileName);

				FindClose (hResult);
			} else {
				// Datei existiert nicht !
				m_szPath[0] = '\0';
				return m_szPath;
			}
			*c = '\\';
		}
	}
	return m_szPath;

}

void TFileSys::OrToNull (char *szBuf)
{
	int i,u;

	u = strlen (szBuf);

	for (i=0;i<u;i++)
		if (szBuf[i] == '|')
			szBuf[i] = '\0';
}

// CreateLink - uses the shell's IShellLink and IPersistFile interfaces
//   to create and store a shortcut to the specified object.
// Returns the hResult of calling the member functions of the interfaces.
// lpszPathObj - addhRess of a buffer containing the path of the object
// lpszPathLink - addhRess of a buffer containing the path where the
//   shell link is to be stored
// lpszDesc - addhRess of a buffer containing the description of the
//   shell link
// 	CoInitialize ();CoUninitialize (); mssen aufgerufen werden


BOOL TFileSys::CreateLink(const char* szPathObj, const char* szPathLink, const char* szDesc)
{
	 HRESULT hRes;
	 IShellLink* psl;

	 // Get a pointer to the IShellLink interface.
	CoInitialize (NULL);

	 hRes = CoCreateInstance(CLSID_ShellLink, NULL,
		  CLSCTX_INPROC_SERVER, IID_IShellLink, (LPVOID *)&psl);
	 if (SUCCEEDED(hRes)) {
		  IPersistFile* ppf;

		  // Set the path to the shortcut target, and add the
		  // description.

		  psl->SetPath(szPathObj);
		  psl->SetDescription(szDesc);

		 // Query IShellLink for the IPersistFile interface for saving the
		 // shortcut in persistent storage.
		  hRes = psl->QueryInterface(IID_IPersistFile,(void**)&ppf);

		  if (SUCCEEDED(hRes)) {
				WORD wsz[MAXPATH];

				// Ensure that the string is ANSI.
				MultiByteToWideChar(CP_ACP, 0, szPathLink, -1,
					 (LPWSTR)wsz, MAXPATH);

				// Save the link by calling IPersistFile::Save.
				hRes = ppf->Save((LPWSTR)wsz, TRUE);
				ppf->Release();
		  }
		  psl->Release();
	 }
	// OLE wieder freigeben
	CoUninitialize ();

	 return hRes;
} 
 
  
// Datei kopieren
// cszSource und cszDest knnen mehrere Durch '\0'
// getrennte Dateien enthalten!
void TFileSys::CopyFile (const char *cszDest,const char *cszSource,BOOL blOverwrite,HWND hParent,const char *cszCaption)
{
	SHFILEOPSTRUCT oData;

	if (blOverwrite == TRUE) {
		// vor dem Copieren die Zieldatei lschen
		remove (cszDest);
	}

	// Nur kopieren, wenn Destination nicht vorhanden!!
	if (FileExist (cszDest) == FALSE) {
		TBuffer bfSource (strlen (cszSource) +2);
		TBuffer bfDest (strlen (cszDest) +2);

		strcpy (bfSource,cszSource);
		strcpy (bfDest,cszDest);

		bfSource.Set (strlen (bfSource)+1,'\0');
		bfDest.Set (strlen (bfDest)+1,'\0');

		// Datemstruct lschen
		memset (&oData,0,sizeof (oData));

		oData.wFunc = FO_COPY;
		oData.hwnd = hParent;
		oData.pFrom = bfSource;
		oData.pTo = bfDest;
		oData.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_NOCONFIRMMKDIR | FOF_SIMPLEPROGRESS;
		oData.lpszProgressTitle = cszCaption;

		SHFileOperation (&oData);
	}
}


// Datei/Pfad lschen
void TFileSys::DeleteFile (const char *cszFile,HWND hParent,const char *cszCaption)
{
	WIN32_FIND_DATA oData;
	HANDLE hFind;

	oData.cFileName [0] = '\0';
	hFind = FindFirstFile (cszFile,&oData);

	if (oData.cFileName[0] != '\0' || PathExist (cszFile) == TRUE) {
		SHFILEOPSTRUCT oData;
		TBuffer bfFile (strlen (cszFile) +2);

		strcpy (bfFile,cszFile);

		bfFile.Set (strlen (bfFile)+1,'\0');

		// Datemstruct lschen
		memset (&oData,0,sizeof (oData));

		oData.wFunc = FO_DELETE;
		oData.hwnd = hParent;
		oData.pFrom = bfFile;
		oData.fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION;
		oData.lpszProgressTitle = cszCaption;

		SHFileOperation (&oData);
	}

	if (hFind != INVALID_HANDLE_VALUE)
		FindClose (hFind);
}


