//*******************************
//   File-System Funktionen
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//  Header
//*******************************
// Klasse ist bereit fr
// Multitasking und - threading
// Bereit fr lange Dateinamen
//*******************************


#ifndef _FILESYS    // schon eingebunden?
	#define _FILESYS

	#define STRICT
	#include <dir.h>


	// import/ export definieren
	#ifndef IMPEX
		#define IMPEX _import
	#endif

	class IMPEX TFileSys
	{
		private :
			// Modul-Pfad:
			char  m_szModulPath [MAXPATH+1];

			// bergabepuffer:
			char m_szPath [MAXPATH+1];
			char m_szDrive [MAXDRIVE+1];
			char m_szDir [MAXDIR+1];
			char m_szFile [MAXFILE+1];
			char m_szExt [MAXEXT+1];

			// Instanz des Aufrufenden Programms
			HINSTANCE hInstance;

			int Split (const char *cszPath); // Aufteilen von path in Komponenten
			void Merge (void); // Komponenten wieder zusammensetzen

		public :

			TFileSys (HINSTANCE hInstance=NULL);

			// evt. Backslash am Ende wird gelscht
			char *NoEndingSlash (const char *cszPath);

			// Ermittelt aus einem Dateinamen den Pfad
			char *ExtractPath (const char *cszFilename);

			// Liefert TRUE, wenn Pfad existiert
			int PathExist (const char *cszPath);

			// Ist Datei zum Schreiben freigegeben?
			int FileAccess (const char *cszFile);

			// Ist Datei vorhanden?
			int FileExist (const char *cszFile);

			// Liefert gltigen Pfad auf Filename1, Filename2 oder Windowsverzeichnis
			char *TraceValidPath (const char *cszFilename1,const char *cszFilename2 = NULL);

			// kpl. Pfad des ak. Pfad ermitteln
			char *GetDirFromDrive (char cDrive);

			// Pfad path erzeugen (mit Unterverzeichnissen)
			int CreatePath (const char *cszPath);

			// Backslash hinzufgen falls noch nicht vorhanden
			char *AddSlash (char *szpath);

			// Pfadangabe auf Anzahl Zeichen begrenzen
			char *ExtractMinPath (const char *cszFilename,const char *cszPath,int iAnzahl = 18);

			// Anhand des alten Names eine Tempdatei im Temp-Verzeichnis erstellen
			char *CreateTempFilename (const char *cszOldName);

			// Windows-Pfad zurckgeben
			char *GetWinPath (void);

			// Filename aus OrgName mit NewPath und NewExt zu einem Pfad+Filename verarbeiten
			char *SetNewPathExt (const char *cszOrgName,const char *cszNewPath,const char *cszNewExt);

			// Pfad und Filename zusammenbringen
			char *AddPathFile (const char *cszPath,const char *cszFile);

			// Extension ndern
			char *SetNewExt (const char *cszOldName,const char *cszExt);

			// Pfad des ausgefhrten Moduls ermitteln
			char *GetModulPath (void);

			// System-Direktory ermitteln
			char *GetSystemPath (void);

			// Absoluten File/Pfad in relativen Pfad relativ zu "Pfad" konvertieren
			char *GetRelPath (const char *cszFile,const char *cszPath);

			// Relativen File/Pfad in absoluten Pfad konvertieren
			char *GetAbsPath (const char *cszFile,const char *cszPath);

			// Resource als Datei speichern
			BOOL SaveResource (unsigned uResType,unsigned uResID,const char *cszFilename);
			BOOL SaveResource (const char *cszResType,unsigned uResID,const char *cszFilename);
			BOOL SaveResource (HRSRC hRes,const char *cszFilename);

			// Dateiname extrahieren
			char *ExtractFilename (const char *cszPathFile);

			// Aus 256-Zeichen Dateiname einen 8.3 Namen erzeugen:
			char *Get83Name (const char *cszLongName);

			// Link von lpszPathObj im Pfad lpszPathLink mit Bezeichnung lpszDesc erzeugen
			BOOL CreateLink (const char* cszPathObj, const char *cszPathLink, const char *cszDesc);

			// | in '\0' wandeln, fr TFileOpen- Dialoge
			void OrToNull (char *szText);

			// eine Datei kopieren
			void CopyFile (const char *cszDest,const char *cszSource,BOOL blOverwrite = FALSE,HWND hParent= 0,const char *cszCaption="");

			// Datei/Pfad lschen
			void DeleteFile (const char *cszFile,HWND hParent= 0,const char *cszCaption="");

	};


#endif // #ifnder _FILESYS
