//*******************************
//   File-System Funktionen
//*******************************
//  (c) 1996 by Olaf Panz
//	 Drosselgasse 4
//  21436 Marschacht
//*******************************
//  Anpassung an Funktionsexport
//   in Delphi
//*******************************
// Klasse ist bereit fr
// Multitasking und - threading
// Bereit fr lange Dateinamen
//*******************************
#define STRICT
#include <windows.h>
#include <filesys.h>
#include <cstring.h>

static string stReturn;

extern "C" {

	int FAR PASCAL _export FSYSPathExist (const char *cszPath)
	{
		return TFileSys ().PathExist (cszPath);
	}

	void FAR PASCAL _export FSYSCreatePath (const char *cszPath)
	{
		TFileSys ().CreatePath (cszPath);
	}

	const char * FAR PASCAL _export FSYSGet83Name (const char *cszLongName)
	{
		stReturn = string (TFileSys().Get83Name (cszLongName));
		return stReturn.c_str();
	}

	void FAR PASCAL _export FSYSCreateLink (const char * cszPathObj,const char *cszPathLink,const char *cszDesc)
	{
		TFileSys().CreateLink (cszPathObj,cszPathLink,cszDesc);
	}

	void FAR PASCAL _export FSYSCopyFile (const char *cszDest,const char *cszSource,BOOL blOverwrite,HWND hParent,const char *cszCaption)
	{
		TFileSys().CopyFile (cszDest,cszSource,blOverwrite,hParent,cszCaption);
	}

	const char* FAR PASCAL _export FSYSExtractPath (const char *cszPath)
	{
		stReturn = string (TFileSys().ExtractPath (cszPath));
		return stReturn.c_str();
	}

	const char* FAR PASCAL _export FSYSExtractFilename (const char *cszPath)
	{
		stReturn = string (TFileSys().ExtractFilename (cszPath));
		return stReturn.c_str();
	}

	void FAR PASCAL _export FSYSDeleteFile (const char *cszFile,HWND hParent,const char *cszCaption)
	{
		TFileSys().DeleteFile (cszFile,hParent,cszCaption);
	}

}
