// INI-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4
//		21436 Marschacht
//
// Datei: iniverw.cpp
//
// Lesen,Bearbeiten,Schreiben von INI-Dateien

#define BUFSIZE 512

#define WIN32_LEAN_AND_MEAN
#define STRICT
#include <windows.h>

#define IMPEX _export
#include "inifile.h"
#include <math.h>


// --------------------------------
// class rtext
// Speichert Infos einer Section
// --------------------------------
rtext::rtext (const char *s) : string (s)
{
}

#ifdef DOREMARK
	FileIO& rtext::GetRemark (FileIO& os)
	{
		if (remark.length ())
			os << "\t; " << remark.c_str ();

		return os;
	}

	const char* rtext::SetRemark (const char* r)
	{
		remark = string (r);
		return r;
	}
#endif



int operator==(const rtext &t1,const rtext &t2) { return !strcmpi (t1.c_str(),t2.c_str()); }

entry::entry (const char *s) : rtext (s)
{
}
// --------------------------------
// 	class entry
// --------------------------------

const char* entry::GetValue (void)
{
	return Value.c_str();
}

const char* entry::SetValue (const char* v)
{
	Value = string(v);
	return Value.c_str ();
}

// --------------------------------
// class section
// Speichert Infos einer Section
// --------------------------------

section::section (const char *s) : rtext (s), Texts (10,0,10), Entries (10,0,10)
{
}

section::~section ()
{
}

void section::Add (rtext* sl)
{
	Texts.Add (sl);
}

void section::Add (entry *el)
{
	Entries.Add (el);
}

unsigned section::GetTextItems (void)
{
	return Texts.GetItemsInContainer ();
}

unsigned section::GetEntryItems (void)
{
	return Entries.GetItemsInContainer ();
}

StrgList* section::GetTexts (void)
{
	return &Texts;
}

EntryList* section::GetEntries (void)
{
	return &Entries;
}



// --------------------------------
// File-Handling-Klasse
// --------------------------------

FileIO& operator<< (FileIO &f,const char *c) { f.settext (c); return f; }

FileIO::FileIO (const char *file,unsigned mode)
{
	of.cBytes = sizeof (OFSTRUCT);
	next = -1;
	loaded = 0;
	Write = FALSE;


	hf = OpenFile (file,&of,mode);

	if (hf != HFILE_ERROR)
		Eof = FALSE;
	else
		Eof = TRUE;
}

FileIO::~FileIO ()
{
	if (Write == TRUE)       // TBuffer sichern
		_lwrite (hf,buf,next);

	if (hf != HFILE_ERROR)
		_lclose (hf);
}

BOOL FileIO::good (void)
{
	if (hf == HFILE_ERROR)
		return FALSE;
	else
		return TRUE;
}


const char *FileIO::getline (void)
{
	int akt;

	if (Eof == TRUE)
		return "";

	if (next == -1) { 	// Es wurde noch nicht geladen
		loaded = _lread (hf,buf,FILEBUF);
		if (loaded == HFILE_ERROR || loaded == 0) {
			Eof = TRUE;
			return "";
		}
		next = 0;
	}

	for (akt = next;akt <= loaded && buf[akt] != '\n';akt++)		// nchste Zeile extrahieren
		;

	if (buf [akt] != '\n') {		// Zeile wurde nicht komplett gelesen!
		akt = loaded-next;
		memmove (buf,buf+next,akt);
		buf[akt] ='\0';

		loaded = _lread (hf,buf+akt,FILEBUF-akt-1) + akt;

		if (loaded == HFILE_ERROR || loaded == 0) {
			Eof = TRUE;
		} else {
			next = 0;
			for (akt = 0;akt <= loaded && buf[akt] != '\n';akt++)		// nchste Zeile extrahieren
				;
		}
	}

	int ret;

	buf[akt-1]='\0';
	ret = next;
	next = akt+1;
	if (next >= loaded)
		next = -1;

	return (char*)buf+ret;

}

void FileIO::settext (const char *b)
{
	unsigned size;

	Write = TRUE;
	if (next == -1) { 	// Start
		next = 0;
		buf [0] = '\0';
	}

	size = strlen (b);

	if ((next + size) > (FILEBUF-1)) {
		// TBuffer speichern
		_lwrite (hf,buf,next);
		next = 0;
		buf [0] = '\0';

		if (size > (FILEBUF-1)) {// Passt nicht in TBuffer
			_lwrite (hf,b,size);
			return;
		}
	}

	strcat (buf,b);
	next += size;
	return;
}



// --------------------------------
// class TTINIFile
// Speichert Infos einer Section
// --------------------------------

TINIFile::TINIFile (const char *File,HINSTANCE inst,BOOL blDetectEntries)
{
	sectionlist = new SectionList (20,0,20);

	char *c,*d,*rem;
	FileIO in (File,OF_READ | OF_SHARE_COMPAT);
	section *se;
	rtext *st;
	entry *et;

	hinstance = inst;

	file = string (File);

	se = NULL;
	if (in.good()) {
		while (in.eof() == FALSE) {    // Sektionsberschrift suchen
			TBuffer buf (in.getline ()); // in.getline ist immer gltig!
			rem = strchr (buf,';'); // Bemerkungen abschneiden
			if (rem) {
				*rem = '\0';
				rem = ExtractText (rem+1);	// Bemerkung merken
			} else
				rem = NULL;

			c = strchr (buf,'[');
			if (c) {
				d = strchr (buf,']');
				if (d) {		// Sektionsname gefunden.
					*d = '\0';
					se = new section (ExtractText(c+1));
					if (se != NULL) {
						#ifdef DOREMARK
							se -> SetRemark (rem);
						#endif
						sectionlist -> Add (se);
					}
				} // end if (d)
			} else if (se) {

				c = ExtractText (buf);
				if (*c != '\0') {		// Zeile hat einen Inhalt:
					d = strchr (buf,'=');	// Entry oder Text ?
					if (d && blDetectEntries == TRUE) {		// Entry !
						if (c < d) {  // Gleichheitszeichen nicht erstes Zeichen in Zeile?
							*d = '\0';
							et = new entry (c);
							if (et != NULL) {
								et -> SetValue (ExtractText(d+1));
								#ifdef DOREMARK
									if (rem != NULL)
										et -> SetRemark (rem);
								#endif
								se -> Add (et);
							}
						} // end if (c < d)
					} else {
						st = new rtext (c);
						if (st != NULL) {
							#ifdef DOREMARK
								if (rem != NULL)
									st -> SetRemark (rem);
							#endif
							se -> Add (st);
						}
					} // end else if (d)
				}

			} // end if (se)
		} //end while
	}

	dosave = FALSE;
}

void TINIFile::Save (void)
{
	unsigned sec,ent,secMax,entMax;
	section *se;
	rtext *rt;
	entry *en;
	SectionListIterator sli (*sectionlist);
	StrgListIterator *str;
	EntryListIterator *eli;

	if (dosave == FALSE) // Nur Speichern, wenn Daten nicht aktuell
		return;

	FileIO of(file.c_str(),OF_CREATE | OF_WRITE);

	secMax = sectionlist -> GetItemsInContainer ();
	for (sec = 0;sec < secMax;sec++) {
		se = sli.Current();
		sli++;
		if (sec != 0)
			of << "\r\n";
		#ifdef DOREMARK
			of << "[" << se->c_str() << "]";
			se -> GetRemark (of) << "\r\n";
		#else
			of << "[" << se->c_str() << "]\r\n";
		#endif

		entMax = se -> GetEntryItems ();
		eli = new EntryListIterator (*(se -> GetEntries()));
		for (ent= 1; ent <= entMax;ent++) {
			en = eli -> Current();
			(*eli)++;
			if (strlen(en -> GetValue ())) { // Nur schreiben, wenn auch Daten vorhanden
				#ifdef DOREMARK
					of << en->c_str() << "=" << en->GetValue();
					en -> GetRemark (of) << "\r\n";
				#else
					of << en->c_str() << "=" << en->GetValue();
					of << "\r\n";
				#endif
			}
		}

		delete eli;

		entMax = se -> GetTextItems ();
		str = new StrgListIterator (*(se -> GetTexts()));
		for (ent= 0; ent < entMax;ent++) {
			rt = str -> Current ();
			(*str)++;
			if (strlen (rt -> c_str ())) { // Nur ausgeben, wenn Daten vorhanden
				#ifdef DOREMARK
					of << rt->c_str();
					rt -> GetRemark (of) << "\r\n";
				#else
					of << rt->c_str() << "\r\n";
				#endif
			}
		}
		delete str;
	}
	of << "\r\n\r\n";

	dosave = FALSE;
}

char *TINIFile::ExtractText (char *t)
{
	char *c;
	c = t + strlen (t)-1;

	while (isspace (*c) && c >= t) {
		*c = '\0';
		c--;
	}
	for (c=t;*c != '0' && isspace (*c);c++)
		;
	return c;
}


TINIFile::~TINIFile ()
{
	Save ();
	if (sectionlist)
		delete sectionlist;
}

// Zugriffsfunktionen

// Entry-Funktionen mit Strings
TStringData TINIFile::GetEntry (TIdentifier oSection,TIdentifier oEntry,TStringData oDefault)
{
	section *se = GetSection (oSection);
	unsigned u;

	if (se) {
		entry en(oEntry);
		u = se -> GetEntries () -> Find (&en); // Eintrag suchen
		if (u != INT_MAX)
			return TStringData ((*(se -> GetEntries ()))[u] ->GetValue());
	}

	return TStringData (oDefault);
}

void TINIFile::SetEntry (TIdentifier oSection,TIdentifier oEntry,TStringData oValue)
{
	section *se = GetSection (oSection);
	entry *ent;
	unsigned u;


	if (!se) {
		se = new section (oSection);
		sectionlist -> Add (se);
		dosave = TRUE;
	}

	entry en(oEntry);
	u = se -> GetEntries () -> Find (&en); // Eintrag suchen
	if (u != INT_MAX) {	// Eintrag vorhanden:
		ent = (*(se -> GetEntries ()))[u];
		if (strcmp (ent -> GetValue (),oValue) != 0) {
			ent -> SetValue (oValue);
			dosave = TRUE;
		}
	} else { // Eintrag neu anlegen
		ent = new entry (oEntry);
		ent -> SetValue (oValue);
		se -> Add (ent);
		dosave = TRUE;
	}

}

void TINIFile::SetEntryDefault (TIdentifier oSection,TIdentifier oEntry,TStringData& oDefault)
{
	section *se = GetSection (oSection);
	entry *ent;
	unsigned u;


	if (!se) {
		se = new section (oSection);
		sectionlist -> Add (se);
		dosave = TRUE;
	}
	entry en(oEntry);
	u = se -> GetEntries () -> Find (&en); // Eintrag suchen
	if (u == INT_MAX) {	// Eintrag nicht vorhanden:
		ent = new entry (oEntry);
		ent -> SetValue (oDefault);
		se -> Add (ent);
		dosave = TRUE;
	}

}

void  TINIFile::DelEntry (TIdentifier oSection,TIdentifier oEntry)
{
	section *se = GetSection (oSection);
	unsigned u;


	if (se) {
		entry en(oEntry);
		u = se -> GetEntries () -> Find (&en); // Eintrag suchen
		if (u != INT_MAX) {	// Eintrag vorhanden:
			se -> GetEntries () -> Destroy (u);
			dosave = TRUE;
			if (se -> GetEntries () -> IsEmpty () && se -> GetTexts () -> IsEmpty()) {// Wenn Sektion leer, Sektion lschen
				sectionlist -> Destroy (se);
			}
		}
	}
}


// Freitext-Funktionen mit Strings
unsigned TINIFile::GetSize (TIdentifier oSection)
{
	section *se = GetSection (oSection);

	if (se) {
		return se -> GetTexts () -> GetItemsInContainer ();
	} else
		return 0;
}

const char *TINIFile::GetText (TIdentifier oSection,unsigned pos)
{
	unsigned i;
	section *se = GetSection (oSection);

	StrgList *rt;


	if (se) {
		rt = se  -> GetTexts ();;
		i= rt -> GetItemsInContainer ();
		if (pos >= i)
			pos = i-1;

		StrgListIterator sli(*rt);

		while (pos >0) {
			sli++;
			pos--;
		}
		return sli.Current () -> c_str ();
	}
	return "";
}

void TINIFile::SetText (TIdentifier oSection,const char *Value,unsigned pos)	// Wenn pos nicht angegeben, wird zugefgt
{
	unsigned u,i;

	section e (oSection);
	section *se = GetSection (oSection);
	StrgList *rt;

	if (!se) {
		se = new section (oSection);
		sectionlist -> Add (se);
	}

	rt = se -> GetTexts ();
	i= rt -> GetItemsInContainer ();


	if (rt -> HasMember (&rtext (Value)) == 0) { // Nur einfgen, wenn Datensatz noch nicht vorhanden
		if (pos >= i || pos == INT_MAX) {
			rt -> Add (new rtext (Value));
		} else {
			StrgListIterator sli(*rt);


			while (pos >0) {
				sli++;
				pos--;
			}
			u = rt -> Find (sli.Current ());
			if (u != INT_MAX)
				rt -> Destroy (u);
			rt -> AddAt (new rtext (Value),u);

		}
		dosave = TRUE;
	}
}

void TINIFile::DelText (TIdentifier oSection,unsigned pos)
{
	unsigned k;

	section *se = GetSection (oSection);
	StrgList *rt;

	if (se) {
		rt = se -> GetTexts ();
		if (pos < rt -> GetItemsInContainer ()) {
			StrgListIterator sli(*rt);

			while (pos >0) {
				sli++;
				pos--;
			}
			k = rt -> Find (sli.Current());
			if (k != INT_MAX)
				rt -> Destroy (k);

			dosave = TRUE;
			if (se -> GetEntries () -> IsEmpty () && rt -> IsEmpty()) // Wenn Sektion leer, Sektion lschen
				sectionlist -> Destroy (se);
		}
	}
}

void TINIFile::DelText (TIdentifier oSection,const char *text)
{
	unsigned i;

	section *se = GetSection (oSection);
	StrgList *rt;

	if (se) {

		rt = se -> GetTexts ();
		i = rt -> Find (&rtext (text));
		if (i != INT_MAX) {
			rt -> Destroy (i);
			dosave = TRUE;
			if (se -> GetEntries () -> IsEmpty () && rt -> IsEmpty()) // Wenn Sektion leer, Sektion lschen
				sectionlist -> Destroy (se);
		}
	}
}



// Section-Funktionen mit Strings
void TINIFile::DelSection (TIdentifier oSection)
{
	unsigned u;

	section e (oSection);

	u = sectionlist -> Find (&e); // Sektion suchen
	if (u != INT_MAX) { // Sektion vorhanden
		sectionlist -> Destroy (u);
		dosave = TRUE;
	}
}

section* TINIFile::GetSection (TIdentifier oSection)
{
	unsigned u;
	const char *szSection = oSection;

	if (strlen(szSection)) {
		section s (szSection);

		u = sectionlist -> Find (&s);
		if (u != INT_MAX)
			return (*sectionlist)[u];
	}
	return NULL;
}


// Ermmittlung von Key-Listen mit Strings
unsigned TINIFile::GetKeyCount (TIdentifier oSection)
{
	section *se = GetSection (oSection);

	if (se) {
		return se -> GetEntries () -> GetItemsInContainer ();
	} else
		return 0;
}

const char *TINIFile::GetKey (TIdentifier oSection,unsigned pos)
{
	unsigned i;

	section *se = GetSection (oSection);
	EntryList *rt;


	if (se) {
		rt = se -> GetEntries ();
		if (rt) {
			i= rt -> GetItemsInContainer ();
			if (pos >= i)
				pos = i-1;

		EntryListIterator sli(*rt);

		while (pos >0) {
			sli++;
			pos--;
		}

		return sli.Current () -> c_str ();

		}
	}
	return "";

}
void TINIFile::DontSave (void)
{
	dosave = FALSE;
}

void TINIFile::DoSave (void)
{
	dosave = TRUE;
}

// Ermittung von Chapter-Listen mit Strings
unsigned TINIFile::GetSectionCount (void) // Liefert die Anzahl der Sectionen
{
	return sectionlist -> GetItemsInContainer ();
}

const char *TINIFile::GetSectionName (unsigned uPos) // Liefert Name der Section ans Position uPos
{
	if (uPos < sectionlist -> GetItemsInContainer () && uPos >= 0) {
		return (*sectionlist)[uPos] -> c_str ();
/*		SectionListIterator oIter (*sectionlist);

		while (uPos > 0) {
			oIter++;
			uPos--;
		}

		return oIter.Current () -> c_str ();*/
	} else
		return "Falscher Index";
}

// Sektion umbennenen, TRUE = Erfolg
BOOL TINIFile::RenameSection (const char *cszOldName,const char *cszNewName)
{
	// umzubenennende Sektion ermitteln :

	section *pOld = GetSection (cszOldName);
	section *pNew = GetSection (cszNewName);

	if (pNew != NULL) {
		// neuer Name existiert schon, kein Umbennenen !!
		return FALSE;
	}

	if (pOld == NULL)
		return TRUE; // Wenn Sektion nicht existiert, braucht auch nicht umbenannt zu werden!

	// umbenennen!

	// zuerst aus der Liste entfernen, damit beim Einfgen wieder Sortiert wird!
	sectionlist -> Detach (pOld);

	// Name ndern
	pOld -> assign (string (cszNewName));

	// und wieder einsortieren
	sectionlist -> Add (pOld);

	dosave = TRUE;

	return TRUE;
}

