// INI-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4                            
//		21436 Marschacht
//
// Datei: iniverw.h
//
// Lesen,Bearbeiten,Schreiben von INI-Dateien


#ifndef INIVERWALTUNG
	#define INIVERWALTUNG
	#include <classlib\arrays.h>
	#include <cstring.h>
	#include <fstream.h>
	#include "buffers.h"
	#include "strdata.h"

	#define FILEBUF 2048

	// Sollen Anmerkungen mit gespeichert werden?
//	#define DOREMARK   1

	#ifndef IMPEX
   	#define IMPEX _import
	#endif


	class FileIO
	{
	private :

		OFSTRUCT of;
		HFILE hf;
		char buf [FILEBUF+1];
		int next;
		int loaded;
		BOOL Eof;
		BOOL Write;

	public :

		FileIO (const char *file,unsigned mode);
		~FileIO ();

		const char *getline (void);
		void settext (const char *b);
		BOOL good (void);
		BOOL eof (void) { return Eof; }
		friend FileIO& operator<< (FileIO &f,const char *c);
	};

	class rtext : public string
	{
		private :

			#ifdef DOREMARK
				string remark;
			#endif

		public :

			rtext (const char *s);

			#ifdef DOREMARK
				FileIO& GetRemark (FileIO& OS);
				const char* SetRemark (const char* r);
			#endif

			friend int operator== (const rtext &t1,const rtext &t2);
	};


	typedef TIArrayAsVector<rtext> StrgList;
	typedef TIArrayAsVectorIterator<rtext> StrgListIterator;

	class entry : public rtext
	{
		private :

			string Value;

		public :

			entry (const char *s);

			const char* GetValue (void);
			const char* SetValue (const char* v);
	};

	typedef TISArrayAsVector<entry> EntryList;
	typedef TISArrayAsVectorIterator<entry> EntryListIterator;


	class IMPEX section : public rtext
	{
		private :

			StrgList Texts;
			EntryList Entries;

		public :

			section (const char *s);
			~section ();
			void Add (rtext* sl);
			void Add (entry *el);

			unsigned GetTextItems (void);
			unsigned GetEntryItems (void);
			StrgList* GetTexts (void);
			EntryList* GetEntries (void);

	};

	typedef TISArrayAsVector<section> SectionList;
	typedef TISArrayAsVectorIterator<section> SectionListIterator;


	// Klasse fr Entry-Texte als Text oder Ressource:
	class TIdentifier
	{
		protected :

			string m_stRes;

		public :

			TIdentifier& operator= (TIdentifier& oRes) { m_stRes = oRes.m_stRes; return *this;}

			// Konvertierungen

			// string
			operator const char* () { return m_stRes.c_str(); }
			const char* operator= (const char *cszRes) { m_stRes = cszRes; return m_stRes.c_str(); }
			TIdentifier (const char *cszRes) {m_stRes = cszRes; }

			TIdentifier (unsigned uRes,HINSTANCE hInstance) : m_stRes (hInstance,uRes) {}

			#ifdef _OWLFAR	// mit OWL:
				TIdentifier (unsigned uRes) : m_stRes (_hInstance,uRes) {}
				const char *operator= (unsigned uRes) { m_stRes = string (_hInstance,uRes);return m_stRes.c_str (); }
			#endif
	};


	class IMPEX TINIFile
	{
		private :

			SectionList *sectionlist;
			BOOL dosave;


		protected :

			char *ExtractText (char *t);
			section* GetSection (TIdentifier oSection);

			HINSTANCE hinstance;
			string file;

		public :

			TINIFile (const char *file,HINSTANCE hi=(HINSTANCE)0,
				BOOL blDetectEntires = TRUE);
			// blDetectEntries: FALSE: Entries werden nicht erkannt
			// alle Daten liegen als Texts vor,

			~TINIFile ();

			void Save (void);  // Speichert nur, wenn Daten verndert wurden!
			void DontSave (void);
			void DoSave (void);

			// Entry-Funktionen
			TStringData GetEntry (TIdentifier oSection,TIdentifier oEntry,TStringData oData= "");
			void SetEntry (TIdentifier oSection,TIdentifier oEntry,TStringData oData);
			void SetEntryDefault (TIdentifier oSection,TIdentifier oEntry,TStringData& oData);
			void DelEntry (TIdentifier oSection,TIdentifier oEntry);

			// Freitext-Funktionen mit Strings
			unsigned GetSize (TIdentifier oSection);
			const char *GetText (TIdentifier oSection,unsigned pos);

			// Wenn pos nicht angegeben, wird zugefgt
			void SetText (TIdentifier oSection,const char *value,unsigned pos= INT_MAX);
			void DelText (TIdentifier oSection,unsigned pos);
			void DelText (TIdentifier oSection,const char *text);

			// Section-Funktionen mit Strings
			void DelSection (TIdentifier oSection);

			// Ermmittlung von Key-Listen mit Strings
			unsigned GetKeyCount (TIdentifier oSection);
			const char *GetKey (TIdentifier oSection,unsigned pos);

			// Ermittung von Chapter-Listen mit Strings
			unsigned GetSectionCount (void); // Liefert die Anzahl der Sectionen
			const char *GetSectionName (unsigned uPos); // Liefert Name der Section ans Position uPos

			BOOL RenameSection (const char *cszOldName,const char *cszNewName);
       
};


#endif
