// INI-Verwaltung
//
// (c) 1995 by Olaf Panz
//
// 	Drosselgasse 4
//		21436 Marschacht
//
// Datei: iniverw.cpp
//
// Zugriff von Delphi heraus

#include <inifile.h>
#include <stdio.h>
static string stReturn;

extern "C" {
	void * FAR PASCAL _export INICreate (const char *cszFile)
	{
		return new TINIFile (cszFile);
	}

	void FAR PASCAL _export INIDestroy (void *pini)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			delete pINI;
		}

	}

	const char * FAR PASCAL _export INIGetEntry (void *pini,const char *cszSection,const char *cszEntry)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			stReturn = string(pINI -> GetEntry (cszSection,cszEntry));
			return stReturn.c_str();
		}
		return "";
	}


	void FAR PASCAL _export INISetEntry (void *pini,const char *cszSection,const char *cszEntry,const char *cszValue)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			pINI -> SetEntry (cszSection,cszEntry,cszValue);
		}
	}

	void FAR PASCAL _export INIDelSection (void *pini,const char *cszSection)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			pINI -> DelSection (cszSection);
		}
	}

	int FAR PASCAL _export INIGetKeyCount (void *pini,const char *cszSection)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			return pINI -> GetKeyCount (cszSection);
		}

		return -1;
	}


	const char * FAR PASCAL _export INIGetKey (void *pini,const char *cszSection,int pos)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			stReturn = string (pINI -> GetKey (cszSection,pos));
			return stReturn.c_str();
		}
		return "";
	}

	int FAR PASCAL _export INIGetSectionCount (void *pini)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			return pINI -> GetSectionCount ();
		}

		return -1;
	}

	const char* FAR PASCAL _export INIGetSectionName (void *pini,int iPos)
	{
		TINIFile *pINI = (TINIFile*) pini;
		if (pINI) {
			stReturn = string (pINI -> GetSectionName (iPos));
					
			return stReturn.c_str();
		}

		return "";
	}

}
